# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralInterestParameters']


class CollateralInterestParameters(BaseDataClass):
    """
    Represents the floating interest calculation and distribution parameters for a single currency.
    """
    postingParty: Optional[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field(None, description="Represents the party to which these parameters apply (the applicable party). In other words, if the parameters are different depending on which party is posting/holding the collateral, for which party to the Collateral Agreement (Party 1 or Party 2) that is posting the collateral do these parameters apply?")
    """
    Represents the party to which these parameters apply (the applicable party).  In other words, if the parameters are different depending on which party is posting/holding the collateral, for which party to the Collateral Agreement (Party 1 or Party 2) that is posting the collateral do these parameters apply?
    """
    marginType: Optional[cdm.product.collateral.CollateralMarginTypeEnum.CollateralMarginTypeEnum] = Field(None, description="Specifies the type of margin for which interest is being calculated, if the parameters are different depending on type of margin (initial or variation).")
    """
    Specifies the type of margin for which interest is being calculated, if the parameters are different depending on type of margin (initial or variation).
    """
    currency: Optional[str] = Field(None, description="Specifies the currency for which the parameters are captured.")
    """
    Specifies the currency for which the parameters are captured.
    """
    interestCalculationParameters: Optional[cdm.product.collateral.CollateralInterestCalculationParameters.CollateralInterestCalculationParameters] = Field(None, description="Represents the basic interest calculation parameters.")
    """
    Represents the basic interest calculation parameters.
    """
    interestCalculationFrequency: Optional[cdm.base.datetime.CalculationFrequency.CalculationFrequency] = Field(None, description="Represents how often and when interest is calculated.")
    """
    Represents how often and when interest is calculated.
    """
    interestHandlingParameters: Optional[cdm.product.collateral.CollateralInterestHandlingParameters.CollateralInterestHandlingParameters] = Field(None, description="Represents the parameters describing how and when interest transfer occurs.")
    """
    Represents the parameters describing how and when interest transfer occurs.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.product.collateral.CollateralMarginTypeEnum
import cdm.product.collateral.CollateralInterestCalculationParameters
import cdm.base.datetime.CalculationFrequency
import cdm.product.collateral.CollateralInterestHandlingParameters
