# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['WeightedAveragingObservation']


class WeightedAveragingObservation(BaseDataClass):
    """
    A single weighted averaging observation.
    """
    dateTime: Optional[datetime.datetime] = Field(None, description="Observation date time, which should be used when literal observation dates are required. The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.")
    """
    Observation date time, which should be used when literal observation dates are required. The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.
    """
    observationNumber: Optional[int] = Field(None, description="Observation number, which should be unique, within a series generated by a date schedule.")
    """
    Observation number, which should be unique, within a series generated by a date schedule.
    """
    weight: Decimal = Field(..., description="Observation weight, which is used as a multiplier for the observation value.")
    """
    Observation weight, which is used as a multiplier for the observation value.
    """
    
    @rosetta_condition
    def condition_0_WeightedAveragingObservationChoice(self):
        """
         Choice rule to represent an FpML choice construct between date times for literal date values, and observation numbers for schedule generated observations.
        """
        item = self
        return rosetta_check_one_of(self, 'dateTime', 'observationNumber', necessity=True)
    
    @rosetta_condition
    def condition_1_PositiveObservationNumber(self):
        """
         FpML specifies observationNumber as a positive integer.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(self, "observationNumber"), ">=", 0)
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "observationNumber")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_PositiveWeight(self):
        """
         FpML specifies observationNumber as a non-negative decimal.
        """
        item = self
        return all_elements(rosetta_resolve_attr(self, "weight"), ">=", 0.0)

import cdm 
