# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.staticdata.asset.common.SecurityTypeEnum import SecurityTypeEnum
from cdm.base.staticdata.asset.common.FundProductTypeEnum import FundProductTypeEnum
from cdm.base.staticdata.asset.common.AssetClassEnum import AssetClassEnum
from cdm.product.template.Product import Product

__all__ = ['Qualify_UnderlierProduct_Equity']


@replaceable
def Qualify_UnderlierProduct_Equity(underlier: Product) -> bool:
    """
    Qualifies a product as having the Asset Class classification Equity.
    
    Parameters 
    ----------
    underlier : Product
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "index"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "EQUITY"))
    
    def _else_fn0():
        return True
    
    is_product =  (((((((all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "EQUITY")) or (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "FUND")) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "security"), "fundType"), "=", rosetta_resolve_attr(FundProductTypeEnum, "EXCHANGE_TRADED_FUND")))) or (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "FUND")) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "security"), "fundType"), "=", rosetta_resolve_attr(FundProductTypeEnum, "MUTUAL_FUND")))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "WARRANT"))) or (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "FUND")) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "security"), "fundType"), "=", rosetta_resolve_attr(FundProductTypeEnum, "OTHER_FUND")))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "CERTIFICATE"))) or (rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "index")) and if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "index"), "productTaxonomy"), "primaryAssetClass")), _then_fn0, _else_fn0))) or (rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket")) and (((((all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"), "basketConstituent"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "EQUITY")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"), "basketConstituent"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "CERTIFICATE"))) or (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"), "basketConstituent"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "FUND")) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"), "basketConstituent"), "security"), "fundType"), "=", rosetta_resolve_attr(FundProductTypeEnum, "EXCHANGE_TRADED_FUND")))) or (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"), "basketConstituent"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "FUND")) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"), "basketConstituent"), "security"), "fundType"), "=", rosetta_resolve_attr(FundProductTypeEnum, "MUTUAL_FUND")))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"), "basketConstituent"), "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "WARRANT"))) or rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "basket"), "basketConstituent"), "index")))))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
