# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Duration']


class Duration(BaseDataClass):
    """
    Specifies the Duration Terms of the Security Financing Transaction, and optionally any Evergreen terms.
    """
    durationType: cdm.product.template.DurationTypeEnum.DurationTypeEnum = Field(..., description="Specifies the Duration Terms of the Security Financing transaction. e.g. Open or Term.")
    """
    Specifies the Duration Terms of the Security Financing transaction. e.g. Open or Term.
    """
    evergreenProvision: Optional[cdm.product.template.EvergreenProvision.EvergreenProvision] = Field(None, description="A data defining: the right of a party to exercise an Evergreen option")
    """
    A data defining: the right of a party to exercise an Evergreen option
    """

import cdm 
import cdm.product.template.DurationTypeEnum
import cdm.product.template.EvergreenProvision
