# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Quanto']


class Quanto(BaseDataClass):
    """
    Determines the currency rate that the seller of the equity amounts will apply at each valuation date for converting the respective amounts into a currency that is different from the currency denomination of the underlier.
    """
    fxRate: List[cdm.observable.asset.FxRate.FxRate] = Field([], description="Specifies a currency conversion rate.")
    """
    Specifies a currency conversion rate.
    """
    fxSpotRateSource: Optional[cdm.observable.asset.FxSpotRateSource.FxSpotRateSource] = Field(None, description="Specifies the methodology (reference source and, optionally, fixing time) to be used for determining a currency conversion rate.")
    """
    Specifies the methodology (reference source and, optionally, fixing time) to be used for determining a currency conversion rate.
    """
    fixingTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="The time at which the spot currency exchange rate will be observed. It is specified as a time in a business day calendar location, e.g. 11:00am London time.")
    """
    The time at which the spot currency exchange rate will be observed. It is specified as a time in a business day calendar location, e.g. 11:00am London time.
    """

import cdm 
import cdm.observable.asset.FxRate
import cdm.observable.asset.FxSpotRateSource
import cdm.base.datetime.BusinessCenterTime
