package drr.base.qualification.event.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.event.ReportableActionEnum;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.ReportableInformation;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsEventTypeUPDT.IsEventTypeUPDTDefault.class)
public abstract class IsEventTypeUPDT implements RosettaFunction {

	/**
	* @param reportableEvent 
	* @return isEventTypeUpdt 
	*/
	public Boolean evaluate(ReportableEventBase reportableEvent) {
		Boolean isEventTypeUpdt = doEvaluate(reportableEvent);
		
		return isEventTypeUpdt;
	}

	protected abstract Boolean doEvaluate(ReportableEventBase reportableEvent);

	protected abstract MapperS<ReportableActionEnum> event(ReportableEventBase reportableEvent);

	public static class IsEventTypeUPDTDefault extends IsEventTypeUPDT {
		@Override
		protected Boolean doEvaluate(ReportableEventBase reportableEvent) {
			Boolean isEventTypeUpdt = null;
			return assignOutput(isEventTypeUpdt, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isEventTypeUpdt, ReportableEventBase reportableEvent) {
			isEventTypeUpdt = exists(event(reportableEvent)).and(areEqual(event(reportableEvent), MapperS.of(ReportableActionEnum.UPDATE), CardinalityOperator.All)).get();
			
			return isEventTypeUpdt;
		}
		
		@Override
		protected MapperS<ReportableActionEnum> event(ReportableEventBase reportableEvent) {
			return MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<ReportableActionEnum>map("getReportableAction", reportableInformation -> reportableInformation.getReportableAction());
		}
	}
}
