package drr.base.qualification.product.functions;

import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsProductWithUnderlier.IsProductWithUnderlierDefault.class)
public abstract class IsProductWithUnderlier implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;

	/**
	* @param product 
	* @return productWithUnderlier 
	*/
	public Boolean evaluate(Product product) {
		Boolean productWithUnderlier = doEvaluate(product);
		
		return productWithUnderlier;
	}

	protected abstract Boolean doEvaluate(Product product);

	protected abstract MapperS<? extends Payout> payout(Product product);

	public static class IsProductWithUnderlierDefault extends IsProductWithUnderlier {
		@Override
		protected Boolean doEvaluate(Product product) {
			Boolean productWithUnderlier = null;
			return assignOutput(productWithUnderlier, product);
		}
		
		protected Boolean assignOutput(Boolean productWithUnderlier, Product product) {
			productWithUnderlier = exists(payout(product).<OptionPayout>mapC("getOptionPayout", _payout -> _payout.getOptionPayout())).or(exists(payout(product).<ForwardPayout>mapC("getForwardPayout", _payout -> _payout.getForwardPayout()))).get();
			
			return productWithUnderlier;
		}
		
		@Override
		protected MapperS<? extends Payout> payout(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout());
		}
	}
}
