package drr.base.trade.basket.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaProductIdentifier;
import cdm.observable.asset.Observable;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetQuantityForConstituent.GetQuantityForConstituentDefault.class)
public abstract class GetQuantityForConstituent implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param identifier 
	* @param tradeLots 
	* @return result 
	*/
	public NonNegativeQuantitySchedule evaluate(String identifier, List<? extends TradeLot> tradeLots) {
		NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder resultBuilder = doEvaluate(identifier, tradeLots);
		
		final NonNegativeQuantitySchedule result;
		if (resultBuilder == null) {
			result = null;
		} else {
			result = resultBuilder.build();
			objectValidator.validate(NonNegativeQuantitySchedule.class, result);
		}
		
		return result;
	}

	protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(String identifier, List<? extends TradeLot> tradeLots);

	public static class GetQuantityForConstituentDefault extends GetQuantityForConstituent {
		@Override
		protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(String identifier, List<? extends TradeLot> tradeLots) {
			if (tradeLots == null) {
				tradeLots = Collections.emptyList();
			}
			NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder result = NonNegativeQuantitySchedule.builder();
			return assignOutput(result, identifier, tradeLots);
		}
		
		protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder result, String identifier, List<? extends TradeLot> tradeLots) {
			final MapperC<PriceQuantity> thenArg0 = MapperC.<TradeLot>of(tradeLots).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
				.filterItemNullSafe(item -> areEqual(item.<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable()).<FieldWithMetaProductIdentifier>mapC("getProductIdentifier", observable -> observable.getProductIdentifier()).<ProductIdentifier>map("Type coercion", fieldWithMetaProductIdentifier -> fieldWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), MapperS.of(identifier), CardinalityOperator.Any).get());
			final MapperListOfLists<FieldWithMetaNonNegativeQuantitySchedule> thenArg1 = thenArg0
				.mapItemToList(item -> item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()));
			final FieldWithMetaNonNegativeQuantitySchedule fieldWithMetaNonNegativeQuantitySchedule = MapperS.of(thenArg1
				.flattenList().get()).get();
			if (fieldWithMetaNonNegativeQuantitySchedule == null) {
				result = null;
			} else {
				result = toBuilder(fieldWithMetaNonNegativeQuantitySchedule.getValue());
			}
			
			return Optional.ofNullable(result)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
