package drr.base.trade.underlier.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FilterProductIdentifier.FilterProductIdentifierDefault.class)
public abstract class FilterProductIdentifier implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param productIdentifiers List of product identifiers
	* @param productIdentificationType 
	* @return productIdentifier Single product identifier
	*/
	public ProductIdentifier evaluate(List<? extends ProductIdentifier> productIdentifiers, ProductIdTypeEnum productIdentificationType) {
		ProductIdentifier.ProductIdentifierBuilder productIdentifierBuilder = doEvaluate(productIdentifiers, productIdentificationType);
		
		final ProductIdentifier productIdentifier;
		if (productIdentifierBuilder == null) {
			productIdentifier = null;
		} else {
			productIdentifier = productIdentifierBuilder.build();
			objectValidator.validate(ProductIdentifier.class, productIdentifier);
		}
		
		return productIdentifier;
	}

	protected abstract ProductIdentifier.ProductIdentifierBuilder doEvaluate(List<? extends ProductIdentifier> productIdentifiers, ProductIdTypeEnum productIdentificationType);

	public static class FilterProductIdentifierDefault extends FilterProductIdentifier {
		@Override
		protected ProductIdentifier.ProductIdentifierBuilder doEvaluate(List<? extends ProductIdentifier> productIdentifiers, ProductIdTypeEnum productIdentificationType) {
			if (productIdentifiers == null) {
				productIdentifiers = Collections.emptyList();
			}
			ProductIdentifier.ProductIdentifierBuilder productIdentifier = ProductIdentifier.builder();
			return assignOutput(productIdentifier, productIdentifiers, productIdentificationType);
		}
		
		protected ProductIdentifier.ProductIdentifierBuilder assignOutput(ProductIdentifier.ProductIdentifierBuilder productIdentifier, List<? extends ProductIdentifier> productIdentifiers, ProductIdTypeEnum productIdentificationType) {
			if (areEqual(MapperC.<ProductIdentifier>of(productIdentifiers).<ProductIdTypeEnum>map("getSource", _productIdentifier -> _productIdentifier.getSource()), MapperS.of(productIdentificationType), CardinalityOperator.Any).getOrDefault(false)) {
				final MapperC<ProductIdentifier> thenArg = MapperC.<ProductIdentifier>of(productIdentifiers)
					.filterItemNullSafe(item -> areEqual(item.<ProductIdTypeEnum>map("getSource", _productIdentifier -> _productIdentifier.getSource()), MapperS.of(productIdentificationType), CardinalityOperator.All).get());
				productIdentifier = toBuilder(thenArg
					.first().get());
			} else {
				productIdentifier = null;
			}
			
			return Optional.ofNullable(productIdentifier)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
