package drr.enrichment.common.trade.functions;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.event.common.CounterpartyPositionState;
import cdm.event.common.PositionIdentifier;
import cdm.event.common.TradeState;
import cdm.event.workflow.WorkflowStep;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.qualification.event.ReportableActionEnum;
import drr.base.trade.ConfirmationMethodEnum;
import drr.base.trade.ExecutionVenueTypeEnum;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.ReportablePriceSource;
import drr.base.trade.ReportingSide;
import drr.base.trade.basket.CustomBasket;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.TransactionReportInstruction;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_TransactionReportInstructionFromInstruction.Create_TransactionReportInstructionFromInstructionDefault.class)
public abstract class Create_TransactionReportInstructionFromInstruction implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_ReportableEventFromInstruction create_ReportableEventFromInstruction;
	@Inject protected Create_ReportingSideFromReportableEvent create_ReportingSideFromReportableEvent;
	@Inject protected Create_TransactionReportInstruction create_TransactionReportInstruction;

	/**
	* @param reportableEvent 
	* @param reportingPartyRole 
	* @param counterpartyRole 
	* @param partyResponsibleForReportingRole 
	* @param reportSubmittingPartyRole 
	* @return transactionReportInstruction 
	*/
	public TransactionReportInstruction evaluate(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole) {
		TransactionReportInstruction.TransactionReportInstructionBuilder transactionReportInstructionBuilder = doEvaluate(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole);
		
		final TransactionReportInstruction transactionReportInstruction;
		if (transactionReportInstructionBuilder == null) {
			transactionReportInstruction = null;
		} else {
			transactionReportInstruction = transactionReportInstructionBuilder.build();
			objectValidator.validate(TransactionReportInstruction.class, transactionReportInstruction);
		}
		
		return transactionReportInstruction;
	}

	protected abstract TransactionReportInstruction.TransactionReportInstructionBuilder doEvaluate(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole);

	protected abstract MapperS<? extends ReportableEventBase> enrichedReportableEventBase(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole);

	protected abstract MapperS<? extends ReportableInformation> reportableInformationBase(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole);

	protected abstract MapperS<? extends ReportableInformation> reportableInformation(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole);

	protected abstract MapperS<? extends ReportableEvent> enrichedReportableEvent(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole);

	protected abstract MapperS<? extends ReportingSide> enrichedReportingSide(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole);

	public static class Create_TransactionReportInstructionFromInstructionDefault extends Create_TransactionReportInstructionFromInstruction {
		@Override
		protected TransactionReportInstruction.TransactionReportInstructionBuilder doEvaluate(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole) {
			TransactionReportInstruction.TransactionReportInstructionBuilder transactionReportInstruction = TransactionReportInstruction.builder();
			return assignOutput(transactionReportInstruction, reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole);
		}
		
		protected TransactionReportInstruction.TransactionReportInstructionBuilder assignOutput(TransactionReportInstruction.TransactionReportInstructionBuilder transactionReportInstruction, ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole) {
			transactionReportInstruction = toBuilder(create_TransactionReportInstruction.evaluate(enrichedReportableEvent(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).get(), enrichedReportingSide(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).get()));
			
			return Optional.ofNullable(transactionReportInstruction)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends ReportableEventBase> enrichedReportableEventBase(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole) {
			return MapperS.of(create_ReportableEventFromInstruction.evaluate(reportableEvent));
		}
		
		@Override
		protected MapperS<? extends ReportableInformation> reportableInformationBase(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole) {
			return enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation());
		}
		
		@Override
		protected MapperS<? extends ReportableInformation> reportableInformation(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole) {
			return MapperS.of(ReportableInformation.builder()
				.setConfirmationMethod(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<ConfirmationMethodEnum>map("getConfirmationMethod", _reportableInformation -> _reportableInformation.getConfirmationMethod()).get())
				.setExecutionVenueType(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<ExecutionVenueTypeEnum>map("getExecutionVenueType", _reportableInformation -> _reportableInformation.getExecutionVenueType()).get())
				.setIntragroup(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<Boolean>map("getIntragroup", _reportableInformation -> _reportableInformation.getIntragroup()).get())
				.setAffiliated(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<Boolean>map("getAffiliated", _reportableInformation -> _reportableInformation.getAffiliated()).get())
				.setLargeSizeTrade(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<Boolean>map("getLargeSizeTrade", _reportableInformation -> _reportableInformation.getLargeSizeTrade()).get())
				.setSefOrDcmAnonymousIndicator(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<Boolean>map("getSefOrDcmAnonymousIndicator", _reportableInformation -> _reportableInformation.getSefOrDcmAnonymousIndicator()).get())
				.setOriginalExecutionTimestamp(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<ZonedDateTime>map("getOriginalExecutionTimestamp", _reportableInformation -> _reportableInformation.getOriginalExecutionTimestamp()).get())
				.setCryptoBased(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<Boolean>map("getCryptoBased", _reportableInformation -> _reportableInformation.getCryptoBased()).get())
				.setUnderlyingAssetLastAvailableSpotPrice(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<PriceSchedule>map("getUnderlyingAssetLastAvailableSpotPrice", _reportableInformation -> _reportableInformation.getUnderlyingAssetLastAvailableSpotPrice()).get())
				.setUnderlyingAssetPriceSource(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<ReportablePriceSource>mapC("getUnderlyingAssetPriceSource", _reportableInformation -> _reportableInformation.getUnderlyingAssetPriceSource()).getMulti())
				.setReportableAction(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<ReportableActionEnum>map("getReportableAction", _reportableInformation -> _reportableInformation.getReportableAction()).get())
				.setSubsequentPositionUTI(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<PositionIdentifier>map("getSubsequentPositionUTI", _reportableInformation -> _reportableInformation.getSubsequentPositionUTI()).get())
				.setCounterpartyPositionPriorUTI(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<PositionIdentifier>map("getCounterpartyPositionPriorUTI", _reportableInformation -> _reportableInformation.getCounterpartyPositionPriorUTI()).get())
				.setCustomBasket(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<CustomBasket>map("getCustomBasket", _reportableInformation -> _reportableInformation.getCustomBasket()).get())
				.setFinalContractualSettlementDate(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<Date>map("getFinalContractualSettlementDate", _reportableInformation -> _reportableInformation.getFinalContractualSettlementDate()).get())
				.setEnrichment(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<ReportableInformation>map("getReportableInformation", reportableEventBase -> reportableEventBase.getReportableInformation()).<EnrichmentData>map("getEnrichment", _reportableInformation -> _reportableInformation.getEnrichment()).get())
				.setPartyInformation(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", _reportableInformation -> _reportableInformation.getPartyInformation()).getMulti())
				.setTransactionInformation(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", _reportableInformation -> _reportableInformation.getTransactionInformation()).getMulti())
				.build());
		}
		
		@Override
		protected MapperS<? extends ReportableEvent> enrichedReportableEvent(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole) {
			return MapperS.of(ReportableEvent.builder()
				.setOriginatingWorkflowStep(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<WorkflowStep>map("getOriginatingWorkflowStep", reportableEventBase -> reportableEventBase.getOriginatingWorkflowStep()).get())
				.setReportableTrade(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<TradeState>map("getReportableTrade", reportableEventBase -> reportableEventBase.getReportableTrade()).get())
				.setReportablePosition(enrichedReportableEventBase(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).<CounterpartyPositionState>map("getReportablePosition", reportableEventBase -> reportableEventBase.getReportablePosition()).get())
				.setReportableInformation(reportableInformation(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).get())
				.build());
		}
		
		@Override
		protected MapperS<? extends ReportingSide> enrichedReportingSide(ReportableEvent reportableEvent, CounterpartyRoleEnum reportingPartyRole, CounterpartyRoleEnum counterpartyRole, CounterpartyRoleEnum partyResponsibleForReportingRole, CounterpartyRoleEnum reportSubmittingPartyRole) {
			return MapperS.of(create_ReportingSideFromReportableEvent.evaluate(enrichedReportableEvent(reportableEvent, reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole).get(), reportingPartyRole, counterpartyRole, partyResponsibleForReportingRole, reportSubmittingPartyRole));
		}
	}
}
