package drr.regulation.asic.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.trade.CommonLeg;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(ASICLegEnrichment.ASICLegEnrichmentDefault.class)
public abstract class ASICLegEnrichment implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param legEnrichment 
	* @param nextFloatingReferenceResetDate 
	* @return asicEnrichedLeg 
	*/
	public CommonLeg evaluate(CommonLeg legEnrichment, Date nextFloatingReferenceResetDate) {
		CommonLeg.CommonLegBuilder asicEnrichedLegBuilder = doEvaluate(legEnrichment, nextFloatingReferenceResetDate);
		
		final CommonLeg asicEnrichedLeg;
		if (asicEnrichedLegBuilder == null) {
			asicEnrichedLeg = null;
		} else {
			asicEnrichedLeg = asicEnrichedLegBuilder.build();
			objectValidator.validate(CommonLeg.class, asicEnrichedLeg);
		}
		
		return asicEnrichedLeg;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(CommonLeg legEnrichment, Date nextFloatingReferenceResetDate);

	public static class ASICLegEnrichmentDefault extends ASICLegEnrichment {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(CommonLeg legEnrichment, Date nextFloatingReferenceResetDate) {
			CommonLeg.CommonLegBuilder asicEnrichedLeg = CommonLeg.builder();
			return assignOutput(asicEnrichedLeg, legEnrichment, nextFloatingReferenceResetDate);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder asicEnrichedLeg, CommonLeg legEnrichment, Date nextFloatingReferenceResetDate) {
			asicEnrichedLeg = toBuilder(legEnrichment, () -> CommonLeg.builder());
			
			asicEnrichedLeg
				.setNextFloatingReferenceResetDate(nextFloatingReferenceResetDate);
			
			return Optional.ofNullable(asicEnrichedLeg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
