package drr.regulation.cftc.rewrite.functions;

import cdm.base.math.functions.Abs;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.event.functions.IsActionTypeTERM;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.functions.BeforeTradeForEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.functions.PayoutFromProductLeg1;
import drr.standards.iosco.cde.version2.quantity.functions.NotionalAmountFormat;
import drr.standards.iosco.cde.version2.quantity.functions.NotionalAmountLeg1;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ChangeInNotionalAmountLeg1.ChangeInNotionalAmountLeg1Default.class)
public abstract class ChangeInNotionalAmountLeg1 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected NotionalAmountFormat notionalAmountFormat;
	@Inject protected NotionalAmountLeg1 notionalAmountLeg1;
	@Inject protected PayoutFromProductLeg1 payoutFromProductLeg1;

	/**
	* @param transactionReportInstruction 
	* @param defaultValue 
	* @return change 
	*/
	public BigDecimal evaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
		BigDecimal change = doEvaluate(transactionReportInstruction, defaultValue);
		
		return change;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue);

	protected abstract MapperS<? extends PayoutLegWithAuxiliary> payoutBefore(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue);

	protected abstract MapperS<BigDecimal> NotionalAmountBefore(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue);

	protected abstract MapperS<BigDecimal> NotionalAmountAfter(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue);

	public static class ChangeInNotionalAmountLeg1Default extends ChangeInNotionalAmountLeg1 {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			BigDecimal change = null;
			return assignOutput(change, transactionReportInstruction, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal change, TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			if (areEqual(NotionalAmountBefore(transactionReportInstruction, defaultValue), MapperS.of(defaultValue), CardinalityOperator.All).or(areEqual(NotionalAmountAfter(transactionReportInstruction, defaultValue), MapperS.of(defaultValue), CardinalityOperator.All)).getOrDefault(false)) {
				change = defaultValue;
			} else {
				final Boolean _boolean = isActionTypeTERM.evaluate(transactionReportInstruction);
				if ((_boolean == null ? false : _boolean)) {
					change = NotionalAmountAfter(transactionReportInstruction, defaultValue).get();
				} else {
					change = abs.evaluate(MapperMaths.<BigDecimal, BigDecimal, BigDecimal>subtract(NotionalAmountAfter(transactionReportInstruction, defaultValue), NotionalAmountBefore(transactionReportInstruction, defaultValue)).get());
				}
			}
			
			return change;
		}
		
		@Override
		protected MapperS<? extends PayoutLegWithAuxiliary> payoutBefore(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			final MapperS<TradableProduct> thenArg = MapperS.of(beforeTradeForEvent.evaluate(transactionReportInstruction)).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct());
			return thenArg
				.mapSingleToItem(item -> MapperS.of(payoutFromProductLeg1.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), MapperS.of(transactionReportInstruction).<ReportableInformation>map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).get())));
		}
		
		@Override
		protected MapperS<BigDecimal> NotionalAmountBefore(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			return MapperS.of(notionalAmountFormat.evaluate(payoutBefore(transactionReportInstruction, defaultValue).get(), defaultValue));
		}
		
		@Override
		protected MapperS<BigDecimal> NotionalAmountAfter(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			return MapperS.of(notionalAmountLeg1.evaluate(transactionReportInstruction, defaultValue));
		}
	}
}
