package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.NaturalPerson;
import cdm.base.staticdata.party.NaturalPersonRole;
import cdm.base.staticdata.party.NaturalPersonRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PersonIdentifier;
import cdm.base.staticdata.party.metafields.FieldWithMetaNaturalPersonRoleEnum;
import cdm.base.staticdata.party.metafields.FieldWithMetaPersonIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.util.party.functions.PartyIdentifierNaturalPersonRoles;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PartyPersonIdExists.PartyPersonIdExistsDefault.class)
public abstract class PartyPersonIdExists implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected PartyIdentifierNaturalPersonRoles partyIdentifierNaturalPersonRoles;

	/**
	* @param party 
	* @return partyPersonIdExists 
	*/
	public Boolean evaluate(Party party) {
		Boolean partyPersonIdExists = doEvaluate(party);
		
		return partyPersonIdExists;
	}

	protected abstract Boolean doEvaluate(Party party);

	protected abstract MapperS<? extends FieldWithMetaString> partyPersonId(Party party);

	public static class PartyPersonIdExistsDefault extends PartyPersonIdExists {
		@Override
		protected Boolean doEvaluate(Party party) {
			Boolean partyPersonIdExists = null;
			return assignOutput(partyPersonIdExists, party);
		}
		
		protected Boolean assignOutput(Boolean partyPersonIdExists, Party party) {
			if (exists(partyPersonId(party)).getOrDefault(false)) {
				partyPersonIdExists = true;
			} else {
				partyPersonIdExists = false;
			}
			
			return partyPersonIdExists;
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> partyPersonId(Party party) {
			final MapperS<Party> thenArg0 = MapperS.of(party)
				.filterSingleNullSafe(item -> areEqual(item.<NaturalPersonRole>mapC("getPersonRole", _party -> _party.getPersonRole()).<FieldWithMetaNaturalPersonRoleEnum>mapC("getRole", naturalPersonRole -> naturalPersonRole.getRole())
					.mapItem(r -> contains(MapperC.<NaturalPersonRoleEnum>of(partyIdentifierNaturalPersonRoles.evaluate()), r.<NaturalPersonRoleEnum>map("Type coercion", fieldWithMetaNaturalPersonRoleEnum -> fieldWithMetaNaturalPersonRoleEnum == null ? null : fieldWithMetaNaturalPersonRoleEnum.getValue())).asMapper()), MapperS.of(true), CardinalityOperator.Any).get());
			final MapperC<FieldWithMetaString> thenArg1 = thenArg0
				.mapSingleToList(item -> item.<NaturalPerson>mapC("getPerson", _party -> _party.getPerson()).<FieldWithMetaPersonIdentifier>mapC("getPersonId", naturalPerson -> naturalPerson.getPersonId()).<PersonIdentifier>map("Type coercion", fieldWithMetaPersonIdentifier -> fieldWithMetaPersonIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", personIdentifier -> personIdentifier.getIdentifier()));
			return MapperS.of(thenArg1.get());
		}
	}
}
