package drr.regulation.common.dtcc.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(DTCC_UnderlyingAssetIDTypeRule.DTCC_UnderlyingAssetIDTypeRuleDefault.class)
public abstract class DTCC_UnderlyingAssetIDTypeRule implements ReportFunction<ProductIdentifier, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ProductIdentifier input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ProductIdentifier input);

	public static class DTCC_UnderlyingAssetIDTypeRuleDefault extends DTCC_UnderlyingAssetIDTypeRule {
		@Override
		protected String doEvaluate(ProductIdentifier input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ProductIdentifier input) {
			if (areEqual(MapperS.of(input).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All).getOrDefault(false)) {
				output = "ISIN";
			} else if (areEqual(MapperC.<ProductIdTypeEnum>of(MapperS.of(ProductIdTypeEnum.BBGID), MapperS.of(ProductIdTypeEnum.BBGTICKER)), MapperS.of(input).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), CardinalityOperator.Any).getOrDefault(false)) {
				output = "Bloomberg";
			} else if (areEqual(MapperS.of(input).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.CUSIP), CardinalityOperator.All).getOrDefault(false)) {
				output = "CUSIP";
			} else if (areEqual(MapperS.of(input).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.RIC), CardinalityOperator.All).getOrDefault(false)) {
				output = "RIC";
			} else if (areEqual(MapperS.of(input).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.SEDOL), CardinalityOperator.All).getOrDefault(false)) {
				output = "SEDOL";
			} else if (areEqual(MapperS.of(input).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.REDID), CardinalityOperator.All).getOrDefault(false)) {
				output = "REDID";
			} else if (areEqual(MapperS.of(input).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.VALOREN), CardinalityOperator.All).getOrDefault(false)) {
				output = "Valoren";
			} else {
				output = "SingleOther";
			}
			
			return output;
		}
	}
}
