package drr.regulation.common.functions;

import cdm.base.datetime.Frequency;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;


@ImplementedBy(FrequencyPeriodMultiplier.FrequencyPeriodMultiplierDefault.class)
public abstract class FrequencyPeriodMultiplier implements RosettaFunction {

	/**
	* @param frequency 
	* @return periodMultiplier 
	*/
	public Integer evaluate(Frequency frequency) {
		Integer periodMultiplier = doEvaluate(frequency);
		
		return periodMultiplier;
	}

	protected abstract Integer doEvaluate(Frequency frequency);

	public static class FrequencyPeriodMultiplierDefault extends FrequencyPeriodMultiplier {
		@Override
		protected Integer doEvaluate(Frequency frequency) {
			Integer periodMultiplier = null;
			return assignOutput(periodMultiplier, frequency);
		}
		
		protected Integer assignOutput(Integer periodMultiplier, Frequency frequency) {
			periodMultiplier = MapperS.of(frequency).<Integer>map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).get();
			
			return periodMultiplier;
		}
	}
}
