package drr.regulation.common.functions;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.IndexEnum;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetIndexIndicatorFromFloatingRate.GetIndexIndicatorFromFloatingRateDefault.class)
public abstract class GetIndexIndicatorFromFloatingRate implements RosettaFunction {

	/**
	* @param floatingRate 
	* @return indicator 
	*/
	public IndexEnum evaluate(String floatingRate) {
		IndexEnum indicator = doEvaluate(floatingRate);
		
		return indicator;
	}

	protected abstract IndexEnum doEvaluate(String floatingRate);

	public static class GetIndexIndicatorFromFloatingRateDefault extends GetIndexIndicatorFromFloatingRate {
		@Override
		protected IndexEnum doEvaluate(String floatingRate) {
			IndexEnum indicator = null;
			return assignOutput(indicator, floatingRate);
		}
		
		protected IndexEnum assignOutput(IndexEnum indicator, String floatingRate) {
			if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_AVERAGE_12_M).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_AVERAGE_1_M).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_AVERAGE_1_W).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_AVERAGE_3_M).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_AVERAGE_6_M).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_COMPOUNDED_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_FTSE_TERM).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_ICE_COMPOUNDED_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_ICE_COMPOUNDED_INDEX_0_FLOOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_ICE_COMPOUNDED_INDEX_0_FLOOR_2_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_ICE_COMPOUNDED_INDEX_0_FLOOR_5_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_ICE_COMPOUNDED_INDEX_2_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_ICE_COMPOUNDED_INDEX_5_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR_TERM).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.ESTR;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.GBP_SONIA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_COMPOUNDED_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_FTSE_TERM).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_COMPOUNDED_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_COMPOUNDED_INDEX_0_FLOOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_COMPOUNDED_INDEX_0_FLOOR_2_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_COMPOUNDED_INDEX_0_FLOOR_5_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_COMPOUNDED_INDEX_2_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_COMPOUNDED_INDEX_5_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_TERM).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_OIS_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_OIS_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_OIS_4_15_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_REFINITIV_TERM).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_WMBA_SONIA_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.SONA;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.USD_SOFR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_AVERAGE_180_D).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_AVERAGE_30_D).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_AVERAGE_90_D).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_CME_TERM).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_COMPOUNDED_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_ICE_COMPOUNDED_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_ICE_COMPOUNDED_INDEX_0_FLOOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_ICE_COMPOUNDED_INDEX_0_FLOOR_2_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_ICE_COMPOUNDED_INDEX_0_FLOOR_5_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_ICE_COMPOUNDED_INDEX_2_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_ICE_COMPOUNDED_INDEX_5_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.SOFR;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.EUR_EONIA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EONIA_OIS_10_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EONIA_OIS_10_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EONIA_OIS_10_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EONIA_OIS_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EONIA_OIS_4_15_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EONIA_OIS_COMPOUND_1).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EONIA_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EONIA_OIS_COMPOUND_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.EONA;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.EUR_EONIA_SWAP_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.EONS;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.EUR_3_M_EURIBOR_SWAP_CME_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_3_M_EURIBOR_SWAP_CME_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_3_M_EURIBOR_SWAP_EUREX_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_3_M_EURIBOR_SWAP_EUREX_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_6_M_EURIBOR_SWAP_CME_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_6_M_EURIBOR_SWAP_CME_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_6_M_EURIBOR_SWAP_EUREX_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_6_M_EURIBOR_SWAP_EUREX_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_ACT_365).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_ACT_365_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_ANNUAL_BOND_SWAP_VS_1_M_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_BASIS_SWAP_1_M_VS_3_M_EURIBOR_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_BASIS_SWAP_3_M_VS_6_M_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_ICE_SWAP_RATE_11_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_ICE_SWAP_RATE_12_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_REUTERS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_TELERATE).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.EURI;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.EUR_USD_BASIS_SWAPS_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.EUUS;
			} else if (false) {
				indicator = IndexEnum.EUCH;
			} else if (false) {
				indicator = IndexEnum.GCFR;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.CAD_ISDA_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_ISDAFIX_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ISDA_EURIBOR_SWAP_RATE_11_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ISDA_EURIBOR_SWAP_RATE_12_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ISDA_LIBOR_SWAP_RATE_10_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ISDA_LIBOR_SWAP_RATE_11_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_ISDA_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_ISDA_SWAP_RATE_11_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_ISDA_SWAP_RATE_4_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_ISDA_SWAP_RATE_10_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_ISDA_SWAP_RATE_15_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_ISDAFIX_3_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_ISDAFIX_3_SWAP_RATE_3_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_ISDA_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_ISDA_SWAP_RATE_3_00).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.ISDA;
			} else if (false) {
				indicator = IndexEnum.LIBI;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.AUD_LIBOR_BBA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_LIBOR_BBA_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_LIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_LIBOR_BBA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_LIBOR_BBA_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_LIBOR_BBA_SWAP_MARKER).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_LIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_3_M_LIBOR_SWAP_CME_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_3_M_LIBOR_SWAP_CME_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_3_M_LIBOR_SWAP_EUREX_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_3_M_LIBOR_SWAP_EUREX_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_6_M_LIBOR_SWAP_CME_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_6_M_LIBORSWAP_CME_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_6_M_LIBOR_SWAP_EUREX_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_6_M_LIBOR_SWAP_EUREX_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR_BBA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR_BBA_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR_ISDA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_LIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_LIBOR_BBA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_LIBOR_BBA_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_LIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_6_M_LIBOR_SWAP_CME_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_6_M_LIBOR_SWAP_CME_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_6_M_LIBOR_SWAP_EUREX_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_6_M_LIBOR_SWAP_EUREX_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_BBA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_BBA_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_ICE_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_ISDA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_BBA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_BBA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_BBA_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_FRASETT).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_ISDA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_TSR_10_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_TSR_15_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_QUOTING_BANKS_LIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_3_M_LIBOR_SWAP_CME_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_3_M_LIBOR_SWAP_CME_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_6_M_LIBOR_SWAP_CME_VS_LCH_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_6_M_LIBOR_SWAP_CME_VS_LCH_ICAP_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_BBA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_BBA_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_ICE_SWAP_RATE_11_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_ICE_SWAP_RATE_15_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_ISDA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_LIBO).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.LIBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.USD_MUNICIPAL_SWAP_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_MUNICIPAL_SWAP_LIBOR_RATIO_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_MUNICIPAL_SWAP_RATE_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.MAAA;
			} else if (false) {
				indicator = IndexEnum.PFAN;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.JPY_EUROYEN_TIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_17096).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_17097).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_DTIBOR01).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_10_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_5_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_ALL_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_ALL_BANKS_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_ZTIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TIBOR_ISDC).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.TIBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.SEK_STIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SEK_STIBOR_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SEK_STIBOR_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SEK_STIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SEK_STIBOR_SIDE).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.STBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.AUD_BBR_AUBBSW).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_BBR_BBSW).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_BBR_BBSW_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_BBSW).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_BBSW_QUARTERLY_SWAP_RATE_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_BBSW_SEMI_ANNUAL_SWAP_RATE_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.BBSW;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.ZAR_JIBAR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.ZAR_JIBAR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.ZAR_JIBAR_SAFEX).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.JIBA;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.HUF_BUBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HUF_BUBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HUF_BUBOR_REUTERS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.BUBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.CAD_BA_CDOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_BA_CDOR_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_CDOR).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.CDOR;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.DKK_CIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR2).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR_2_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR2_DKNA13).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR_DKNA13).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR_DKNA_13_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.CIBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.RUB_MOS_PRIME).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.RUB_MOSPRIME_NFEA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.RUB_MOSPRIME_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.MOSP;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.NOK_NIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_NIBR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_NIBR_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_NIBR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_OIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.NIBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.CZK_PRIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CZK_PRIBOR_PRBO).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CZK_PRIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.PRBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.ILS_TELBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.ILS_TELBOR_01_REUTERS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.ILS_TELBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.TLBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.PLN_WIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.PLN_WIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.PLN_WIBOR_WIBO).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.PLZ_WIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.PLZ_WIBOR_WIBO).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.WIBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.CAD_TBILL_ISDD).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_TBILL_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_TBILL_REUTERS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_TBILL_TELERATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TBILL_AUCTION_HIGH_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TBILL_H_15).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TBILL_H_15_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TBILL_SECONDARY_MARKET).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TBILL_SECONDARY_MARKET_BOND_EQUIVALENT_YIELD).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_19901_3_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_BCMP_1).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_ICAP_BROKER_TEC).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_SWAP_MARKER_100).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_SWAP_MARKER_99).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_T_19901).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_T_500).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.TREA;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.AUD_QUARTERLY_SWAP_RATE_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_QUARTERLY_SWAP_RATE_ICAP_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_SEMI_ANNUAL_SWAP_RATE_BGCANTOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_SEMI_ANNUAL_SWAP_RATE_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_SEMI_ANNUAL_SWAP_RATE_ICAP_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.AUD_SWAP_RATE_REUTERS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_ANNUAL_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_ANNUAL_SWAP_RATE_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_BASIS_SWAP_3_M_VS_6_M_LIBOR_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_OIS_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CHF_USD_BASIS_SWAPS_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CNY_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CNY_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CZK_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CZK_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_SWAP_MARKER).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_11_00).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_11_00_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_11_00_SWAP_MARKER).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_3_MONTH).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_3_MONTH_SWAP_MARKER).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_4_15_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.EUR_BASIS_SWAP_EONIA_VS_3_M_EUR_IBOR_SWAP_RATES_A_360_10_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_4_15_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_SWAP_MARKER_26).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.GBP_USD_BASIS_SWAPS_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_ANNUAL_SWAP_RATE_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_ANNUAL_SWAP_RATE_4_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_QUARTERLY_SWAP_RATE_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_QUARTERLY_SWAP_RATE_4_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_QUARTERLY_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.IDR_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.IDR_SEMI_ANNUAL_SWAP_RATE_NON_DELIVERABLE_16_00_TULLETT_PREBON).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.IDR_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.INR_SEMI_ANNUAL_SWAP_RATE_11_30_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.INR_SEMI_ANNUAL_SWAP_RATE_NON_DELIVERABLE_16_00_TULLETT_PREBON).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.INR_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_ANNUAL_SWAP_RATE_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_ANNUAL_SWAP_RATE_3_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_OIS_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_OIS_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_OIS_3_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_USD_BASIS_SWAPS_11_00_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.KRW_QUARTERLY_ANNUAL_SWAP_RATE_3_30_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.MYR_QUARTERLY_SWAP_RATE_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.MYR_QUARTERLY_SWAP_RATE_TRADITION_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.NZD_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.NZD_SEMI_ANNUAL_SWAP_RATE_BGCANTOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.NZD_SWAP_RATE_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.NZD_SWAP_RATE_ICAP_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.PHP_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.PHP_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.RON_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.RON_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_12_45_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_4_15_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_TRADITION_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SEK_ANNUAL_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SEK_ANNUAL_SWAP_RATE_SESWFI).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_CURRENCY_BASIS_SWAP_RATE_11_00_TULLETT_PREBON).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_CURRENCY_BASIS_SWAP_RATE_16_00_TULLETT_PREBON).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_11_00_TULLETT_PREBON).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_16_00_TULLETT_PREBON).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_ICAP_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_TRADITION_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.THB_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.THB_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.TRY_ANNUAL_SWAP_RATE_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.TRY_ANNUAL_SWAP_RATE_11_15_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.TRY_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.TRY_SEMI_ANNUAL_SWAP_RATE_TRADITION_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.TWD_QUARTERLY_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.TWD_QUARTERLY_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_ANNUAL_SWAP_RATE_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_ANNUAL_SWAP_RATE_4_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_OIS_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_OIS_11_00_LON_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_OIS_11_00_NY_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_OIS_11_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_OIS_3_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_OIS_3_00_NY_ICAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_OIS_4_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_ICE_TERM).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SOFR_ICE_SWAP_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SWAP_RATE_BCMP_1).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.VND_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.VND_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.ZAR_QUARTERLY_SWAP_RATE_1_00_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.ZAR_QUARTERLY_SWAP_RATE_5_30_TRADITION).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.ZAR_QUARTERLY_SWAP_RATE_TRADITION_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.SWAP;
			} else if (false) {
				indicator = IndexEnum.FUSW;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS_H_15).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS_H_15_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS_H_15_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS_REFERENCE_DEALERS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.EFFR;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.USD_OVERNIGHT_BANK_FUNDING_RATE).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.OBFR;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.CZK_CZEONIA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CZK_CZEONIA_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.CZNA;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.CAD_CORRA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_CORRA_OIS_COMPOUND_1).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_CORRA_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_CORRA_COMPOUNDED_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CAD_REPO_CORRA).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.CORA;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.HKD_HIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_HIBOR_HIBOR_).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_HIBOR_HIBOR_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_HIBOR_HKAB).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_HIBOR_HKAB_BLOOMBERG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_HIBOR_ISDC).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.HKD_HIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CNH_HIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CNH_HIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.CNH_HIBOR_TMA).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.HKIO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.JPY_TONA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_AVERAGE_180_D).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_AVERAGE_30_D).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_AVERAGE_90_D).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_COMPOUNDED_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_ICE_COMPOUNDED_INDEX).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_ICE_COMPOUNDED_INDEX_0_FLOOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_ICE_COMPOUNDED_INDEX_0_FLOOR_2_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_ICE_COMPOUNDED_INDEX_0_FLOOR_5_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_ICE_COMPOUNDED_INDEX_2_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_ICE_COMPOUNDED_INDEX_5_D_LAG).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_OIS_COMPOUND_1).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.JPY_TONA_TSR_10_00).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.TONA;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.JPY_TORF_QUICK).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.TORF;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.USD_SIBOR_SIBO).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.USD_SIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SIBOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SIBOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SIBOR_REUTERS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SIBOR_TELERATE).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.SIBO;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.SGD_SOR).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SOR_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SOR_REUTERS).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SOR_TELERATE).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SOR_VWAP).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SOR_VWAP_REFERENCE_BANKS).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.SSOR;
			} else if (areEqual(MapperC.<String>of(MapperS.of(FloatingRateIndexEnum.SGD_SORA).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SORA_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(FloatingRateIndexEnum.SGD_SORA_OIS_COMPOUND).map("to-string", FloatingRateIndexEnum::toDisplayString)), MapperS.of(floatingRate), CardinalityOperator.Any).getOrDefault(false)) {
				indicator = IndexEnum.SORA;
			} else {
				indicator = null;
			}
			
			return indicator;
		}
	}
}
