package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.template.ContractualProduct;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetIsin.GetIsinDefault.class)
public abstract class GetIsin implements RosettaFunction {

	/**
	* @param product 
	* @return isin 
	*/
	public String evaluate(Product product) {
		String isin = doEvaluate(product);
		
		return isin;
	}

	protected abstract String doEvaluate(Product product);

	public static class GetIsinDefault extends GetIsin {
		@Override
		protected String doEvaluate(Product product) {
			String isin = null;
			return assignOutput(isin, product);
		}
		
		protected String assignOutput(String isin, Product product) {
			final MapperS<Product> thenArg = MapperS.of(product);
			final FieldWithMetaString fieldWithMetaString = thenArg
				.mapSingleToItem(item -> {
					final MapperC<ReferenceWithMetaProductIdentifier> thenArg0 = MapperC.<ReferenceWithMetaProductIdentifier>of(item.<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier()), item.<Security>map("getSecurity", _product -> _product.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier()))
						.filterItemNullSafe(_item -> areEqual(_item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All).get());
					final MapperS<ReferenceWithMetaProductIdentifier> thenArg1 = MapperS.of(thenArg0.get());
					return thenArg1
						.mapSingleToItem(_item -> _item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()));
				}).get();
			if (fieldWithMetaString == null) {
				isin = null;
			} else {
				isin = fieldWithMetaString.getValue();
			}
			
			return isin;
		}
	}
}
