package drr.regulation.common.functions;

import cdm.event.common.Trade;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.qualification.product.functions.IsEquitySwap;
import drr.base.qualification.product.functions.IsFXForward;
import drr.base.qualification.product.functions.IsFXOption;
import drr.base.qualification.product.functions.IsFXSwap;
import drr.base.qualification.product.functions.IsGenericIRS;
import drr.base.qualification.product.functions.IsIRSwaption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(GetLeg2ResolvablePriceQuantity.GetLeg2ResolvablePriceQuantityDefault.class)
public abstract class GetLeg2ResolvablePriceQuantity implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXLeg2 fXLeg2;
	@Inject protected FXSwapLeg2 fXSwapLeg2;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsEquitySwap isEquitySwap;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsGenericIRS isGenericIRS;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param trade 
	* @return priceQuantity 
	*/
	public ResolvablePriceQuantity evaluate(Trade trade) {
		ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantityBuilder = doEvaluate(trade);
		
		final ResolvablePriceQuantity priceQuantity;
		if (priceQuantityBuilder == null) {
			priceQuantity = null;
		} else {
			priceQuantity = priceQuantityBuilder.build();
			objectValidator.validate(ResolvablePriceQuantity.class, priceQuantity);
		}
		
		return priceQuantity;
	}

	protected abstract ResolvablePriceQuantity.ResolvablePriceQuantityBuilder doEvaluate(Trade trade);

	protected abstract MapperS<? extends Product> product(Trade trade);

	public static class GetLeg2ResolvablePriceQuantityDefault extends GetLeg2ResolvablePriceQuantity {
		@Override
		protected ResolvablePriceQuantity.ResolvablePriceQuantityBuilder doEvaluate(Trade trade) {
			ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity = ResolvablePriceQuantity.builder();
			return assignOutput(priceQuantity, trade);
		}
		
		protected ResolvablePriceQuantity.ResolvablePriceQuantityBuilder assignOutput(ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity, Trade trade) {
			final Boolean boolean0 = isIRSwaption.evaluate(product(trade).get());
			if ((boolean0 == null ? false : boolean0)) {
				final MapperS<InterestRatePayout> thenArg = MapperS.of(interestRateLeg2.evaluate(underlierForProduct.evaluate(product(trade).get())));
				priceQuantity = toBuilder(thenArg
					.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity())).get());
			} else if (ComparisonResult.of(MapperS.of(isGenericIRS.evaluate(product(trade).get()))).or(ComparisonResult.of(MapperS.of(isEquitySwap.evaluate(MapperS.of(trade).<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).get())))).getOrDefault(false)) {
				priceQuantity = toBuilder(MapperS.of(interestRateLeg2.evaluate(product(trade).get()))
					.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity())).get());
			} else {
				final Boolean boolean1 = isFXForward.evaluate(product(trade).get());
				if ((boolean1 == null ? false : boolean1)) {
					priceQuantity = toBuilder(MapperS.of(fXLeg2.evaluate(product(trade).get()))
						.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity())).get());
				} else {
					final Boolean boolean2 = isFXOption.evaluate(product(trade).get());
					if ((boolean2 == null ? false : boolean2)) {
						priceQuantity = toBuilder(MapperS.of(fXLeg2.evaluate(product(trade).get()))
							.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity())).get());
					} else {
						final Boolean boolean3 = isFXSwap.evaluate(product(trade).get());
						if ((boolean3 == null ? false : boolean3)) {
							priceQuantity = toBuilder(MapperS.of(fXSwapLeg2.evaluate(product(trade).get())).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).get());
						} else {
							final Boolean boolean4 = isCommoditySwap.evaluate(product(trade).get());
							if ((boolean4 == null ? false : boolean4)) {
								priceQuantity = toBuilder(MapperS.of(commodityLeg2.evaluate(product(trade).get())).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).get());
							} else {
								final Boolean boolean5 = qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(product(trade).get()));
								if ((boolean5 == null ? false : boolean5)) {
									priceQuantity = toBuilder(MapperS.of(commodityLeg2.evaluate(underlierForProduct.evaluate(product(trade).get()))).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).get());
								} else {
									final Boolean boolean6 = qualify_Commodity_Forward.evaluate(economicTermsForProduct.evaluate(product(trade).get()));
									if ((boolean6 == null ? false : boolean6)) {
										priceQuantity = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product(trade).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).get());
									} else {
										priceQuantity = null;
									}
								}
							}
						}
					}
				}
			}
			
			return Optional.ofNullable(priceQuantity)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends Product> product(Trade trade) {
			return MapperS.of(productForTrade.evaluate(trade));
		}
	}
}
