package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetTransactionInformationForRegime.GetTransactionInformationForRegimeDefault.class)
public abstract class GetTransactionInformationForRegime implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param transaction 
	* @param regime 
	* @param supervisoryBodyIn 
	* @return transactionInformation 
	*/
	public TransactionInformation evaluate(TransactionReportInstruction transaction, RegimeNameEnum regime, SupervisoryBodyEnum supervisoryBodyIn) {
		TransactionInformation.TransactionInformationBuilder transactionInformationBuilder = doEvaluate(transaction, regime, supervisoryBodyIn);
		
		final TransactionInformation transactionInformation;
		if (transactionInformationBuilder == null) {
			transactionInformation = null;
		} else {
			transactionInformation = transactionInformationBuilder.build();
			objectValidator.validate(TransactionInformation.class, transactionInformation);
		}
		
		return transactionInformation;
	}

	protected abstract TransactionInformation.TransactionInformationBuilder doEvaluate(TransactionReportInstruction transaction, RegimeNameEnum regime, SupervisoryBodyEnum supervisoryBodyIn);

	public static class GetTransactionInformationForRegimeDefault extends GetTransactionInformationForRegime {
		@Override
		protected TransactionInformation.TransactionInformationBuilder doEvaluate(TransactionReportInstruction transaction, RegimeNameEnum regime, SupervisoryBodyEnum supervisoryBodyIn) {
			TransactionInformation.TransactionInformationBuilder transactionInformation = TransactionInformation.builder();
			return assignOutput(transactionInformation, transaction, regime, supervisoryBodyIn);
		}
		
		protected TransactionInformation.TransactionInformationBuilder assignOutput(TransactionInformation.TransactionInformationBuilder transactionInformation, TransactionReportInstruction transaction, RegimeNameEnum regime, SupervisoryBodyEnum supervisoryBodyIn) {
			final MapperC<TransactionInformation> thenArg0 = MapperS.of(transaction).<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation());
			final MapperC<TransactionInformation> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaRegimeNameEnum>map("getRegimeName", _transactionInformation -> _transactionInformation.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(regime), CardinalityOperator.All).and(areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", _transactionInformation -> _transactionInformation.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(supervisoryBodyIn), CardinalityOperator.All).or(notExists(MapperS.of(supervisoryBodyIn)))).get());
			transactionInformation = toBuilder(MapperS.of(thenArg1.get()).get());
			
			return Optional.ofNullable(transactionInformation)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
