package drr.regulation.common.trade.index.reports;

import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.GeneralTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iso.functions.FormatToMax5Number;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SeriesRule.SeriesRuleDefault.class)
public abstract class SeriesRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FormatToMax5Number formatToMax5Number;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class SeriesRuleDefault extends SeriesRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg0 = MapperS.of(productForEvent.evaluate(input));
			final MapperS<CreditDefaultPayout> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).getOrDefault(false)) {
						return MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout());
					}
					if (exists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).getOrDefault(false)) {
						return MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout());
					}
					return MapperS.<CreditDefaultPayout>ofNull();
				});
			final MapperS<Integer> thenArg2 = thenArg1
				.mapSingleToItem(item -> item.<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<Integer>map("getIndexSeries", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexSeries()));
			final Integer integer = thenArg2.get();
			output = MapperS.of(formatToMax5Number.evaluate((integer == null ? null : BigDecimal.valueOf(integer)))).get();
			
			return output;
		}
	}
}
