package drr.regulation.common.trade.underlier.reports;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.observable.asset.FloatingRateOption;
import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.RateOption;
import javax.inject.Inject;


@ImplementedBy(FloatingRateIdentifierRule.FloatingRateIdentifierRuleDefault.class)
public abstract class FloatingRateIdentifierRule implements ReportFunction<InterestRatePayout, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected RateOption rateOption;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(InterestRatePayout input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(InterestRatePayout input);

	public static class FloatingRateIdentifierRuleDefault extends FloatingRateIdentifierRule {
		@Override
		protected String doEvaluate(InterestRatePayout input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, InterestRatePayout input) {
			final MapperS<FloatingRateOption> thenArg = MapperS.of(rateOption.evaluate(input));
			final FieldWithMetaString fieldWithMetaString = thenArg
				.mapSingleToItem(item -> MapperS.of(item.<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<ProductIdentifier>mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get())).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
