package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.HKMAPartyInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 7.0.0-dev.52
 */
@RosettaDataRule("ReportingRegimeHKMAReportingRegime")
@ImplementedBy(ReportingRegimeHKMAReportingRegime.Default.class)
public interface ReportingRegimeHKMAReportingRegime extends Validator<ReportingRegime> {
	
	String NAME = "ReportingRegimeHKMAReportingRegime";
	String DEFINITION = "if supervisoryBody = SupervisoryBodyEnum -> HKMA then hkmaPartyInformation exists else hkmaPartyInformation is absent";
	
	class Default implements ReportingRegimeHKMAReportingRegime {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
			ComparisonResult result = executeDataRule(reportingRegime);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportingRegime", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportingRegime", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ReportingRegime reportingRegime) {
			try {
				if (areEqual(MapperS.of(reportingRegime).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", _reportingRegime -> _reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.HKMA), CardinalityOperator.All).getOrDefault(false)) {
					return exists(MapperS.of(reportingRegime).<HKMAPartyInformation>map("getHkmaPartyInformation", _reportingRegime -> _reportingRegime.getHkmaPartyInformation()));
				}
				return notExists(MapperS.of(reportingRegime).<HKMAPartyInformation>map("getHkmaPartyInformation", _reportingRegime -> _reportingRegime.getHkmaPartyInformation()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ReportingRegimeHKMAReportingRegime {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
			return Collections.emptyList();
		}
	}
}
