package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg1Rule;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg2Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.functions.FloatingInterestRatePayoutFromPayout;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierRule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodRule;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg1;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg2;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg1Rule;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg2Rule;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1CommodityInstrumentIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1CommodityUnderlyerIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1FloatingRateIndexRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg2CommodityInstrumentIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg2CommodityUnderlyerIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg2FloatingRateIndexRule;
import drr.regulation.csa.rewrite.functions.CSALegEnrichment;
import drr.regulation.csa.rewrite.trade.CSALeg;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg1Aligned;
import drr.standards.iosco.cde.version3.functions.Leg1;
import drr.standards.iosco.cde.version3.functions.Leg2;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleRule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleRule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Leg1ReportPPDRule.Leg1ReportPPDRuleDefault.class)
public abstract class Leg1ReportPPDRule implements ReportFunction<TransactionReportInstruction, CSALeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CSALegEnrichment cSALegEnrichment;
	@Inject protected DTCC_Leg1CommodityInstrumentIDRule dTCC_Leg1CommodityInstrumentIDRule;
	@Inject protected DTCC_Leg1CommodityUnderlyerIDRule dTCC_Leg1CommodityUnderlyerIDRule;
	@Inject protected DTCC_Leg1FloatingRateIndexRule dTCC_Leg1FloatingRateIndexRule;
	@Inject protected DTCC_Leg2CommodityInstrumentIDRule dTCC_Leg2CommodityInstrumentIDRule;
	@Inject protected DTCC_Leg2CommodityUnderlyerIDRule dTCC_Leg2CommodityUnderlyerIDRule;
	@Inject protected DTCC_Leg2FloatingRateIndexRule dTCC_Leg2FloatingRateIndexRule;
	@Inject protected FixingDateLeg1Rule fixingDateLeg1Rule;
	@Inject protected FixingDateLeg2Rule fixingDateLeg2Rule;
	@Inject protected FloatingInterestRatePayoutFromPayout floatingInterestRatePayoutFromPayout;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierRule floatingRateResetFrequencyPeriodMultiplierRule;
	@Inject protected FloatingRateResetFrequencyPeriodRule floatingRateResetFrequencyPeriodRule;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSALeg1Aligned isCSALeg1Aligned;
	@Inject protected Leg1 leg1;
	@Inject protected Leg2 leg2;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NotionalAmountScheduleRule notionalAmountScheduleRule;
	@Inject protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
	@Inject protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
	@Inject protected NotionalQuantityScheduleRule notionalQuantityScheduleRule;
	@Inject protected PayoutLeg1Rule payoutLeg1Rule;
	@Inject protected PayoutLeg2Rule payoutLeg2Rule;
	@Inject protected QuantityFrequencyLeg1 quantityFrequencyLeg1;
	@Inject protected QuantityFrequencyLeg2 quantityFrequencyLeg2;
	@Inject protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
	@Inject protected SpreadNotationLeg1Rule spreadNotationLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CSALeg evaluate(TransactionReportInstruction input) {
		CSALeg.CSALegBuilder outputBuilder = doEvaluate(input);
		
		final CSALeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CSALeg.class, output);
		}
		
		return output;
	}

	protected abstract CSALeg.CSALegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg1ReportPPDRuleDefault extends Leg1ReportPPDRule {
		@Override
		protected CSALeg.CSALegBuilder doEvaluate(TransactionReportInstruction input) {
			CSALeg.CSALegBuilder output = CSALeg.builder();
			return assignOutput(output, input);
		}
		
		protected CSALeg.CSALegBuilder assignOutput(CSALeg.CSALegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final Boolean _boolean = isCSALeg1Aligned.evaluate(thenArg.get());
			final MapperS<CSALeg> ifThenElseResult;
			if ((_boolean == null ? false : _boolean)) {
				final BigDecimal bigDecimal0 = floatingRateResetFrequencyPeriodMultiplierRule.evaluate(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(thenArg.get())));
				ifThenElseResult = MapperS.of(cSALegEnrichment.evaluate(legEnrichment.evaluate(leg1.evaluate(thenArg.get(), spreadNotationLeg1Rule.evaluate(thenArg.get()), new BigDecimal("99999999999999999999.99999")), notionalAmountScheduleRule.evaluate(payoutLeg1Rule.evaluate(thenArg.get())), notionalQuantityScheduleRule.evaluate(payoutLeg1Rule.evaluate(thenArg.get())), notionalQuantityLeg1Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodRule.evaluate(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(thenArg.get()))), (bigDecimal0 == null ? null : bigDecimal0.intValueExact()), fixingDateLeg1Rule.evaluate(thenArg.get()), MapperS.of(quantityFrequencyLeg1.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get(), MapperS.of(quantityFrequencyLeg1.evaluate(thenArg.get())).<Integer>map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), null, null, null, null, null), quantityUnitOfMeasureLeg1Rule.evaluate(thenArg.get()), null, null, null, null, null, null, null, null, dTCC_Leg1CommodityUnderlyerIDRule.evaluate(thenArg.get()), dTCC_Leg1CommodityInstrumentIDRule.evaluate(thenArg.get()), dTCC_Leg1FloatingRateIndexRule.evaluate(thenArg.get())));
			} else {
				final BigDecimal bigDecimal1 = floatingRateResetFrequencyPeriodMultiplierRule.evaluate(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg2Rule.evaluate(thenArg.get())));
				ifThenElseResult = MapperS.of(cSALegEnrichment.evaluate(legEnrichment.evaluate(leg2.evaluate(thenArg.get(), spreadNotationLeg1Rule.evaluate(thenArg.get()), new BigDecimal("99999999999999999999.99999")), notionalAmountScheduleRule.evaluate(payoutLeg2Rule.evaluate(thenArg.get())), notionalQuantityScheduleRule.evaluate(payoutLeg2Rule.evaluate(thenArg.get())), notionalQuantityLeg2Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodRule.evaluate(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg2Rule.evaluate(thenArg.get()))), (bigDecimal1 == null ? null : bigDecimal1.intValueExact()), fixingDateLeg2Rule.evaluate(thenArg.get()), MapperS.of(quantityFrequencyLeg2.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get(), MapperS.of(quantityFrequencyLeg2.evaluate(thenArg.get())).<Integer>map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), null, null, null, null, null), quantityUnitOfMeasureLeg1Rule.evaluate(thenArg.get()), null, null, null, null, null, null, null, null, dTCC_Leg2CommodityUnderlyerIDRule.evaluate(thenArg.get()), dTCC_Leg2CommodityInstrumentIDRule.evaluate(thenArg.get()), dTCC_Leg2FloatingRateIndexRule.evaluate(thenArg.get())));
			}
			output = toBuilder(ifThenElseResult.get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
