package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.price.PriceNotationEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.price.functions.DefaultPercentageToDecimal;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg1Aligned;
import drr.standards.iosco.cde.version3.price.reports.SpreadNotationEnumRule;
import javax.inject.Inject;


@ImplementedBy(SpreadNotationLeg1Rule.SpreadNotationLeg1RuleDefault.class)
public abstract class SpreadNotationLeg1Rule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected DefaultPercentageToDecimal defaultPercentageToDecimal;
	@Inject protected IsCSALeg1Aligned isCSALeg1Aligned;
	@Inject protected PayoutLeg1Rule payoutLeg1Rule;
	@Inject protected PayoutLeg2Rule payoutLeg2Rule;
	@Inject protected SpreadNotationEnumRule spreadNotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadNotationLeg1RuleDefault extends SpreadNotationLeg1Rule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCSALeg1Aligned.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(defaultPercentageToDecimal.evaluate(spreadNotationEnumRule.evaluate(payoutLeg1Rule.evaluate(item.get())), false));
					}
					return MapperS.of(defaultPercentageToDecimal.evaluate(spreadNotationEnumRule.evaluate(payoutLeg2Rule.evaluate(item.get())), false));
				}).get();
			
			return output;
		}
	}
}
