package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReportTrade;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 7.0.0-dev.52
 */
@RosettaDataRule("CSATransactionReportTradeDTCC_CSA_VR_0020_01")
@ImplementedBy(CSATransactionReportTradeDTCC_CSA_VR_0020_01.Default.class)
public interface CSATransactionReportTradeDTCC_CSA_VR_0020_01 extends Validator<CSATransactionReportTrade> {
	
	String NAME = "CSATransactionReportTradeDTCC_CSA_VR_0020_01";
	String DEFINITION = "if platformAnonymousExecutionIndicator = False or platformAnonymousExecutionIndicator is absent then interAffiliateIndicator exists";
	
	class Default implements CSATransactionReportTradeDTCC_CSA_VR_0020_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
			ComparisonResult result = executeDataRule(cSATransactionReportTrade);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReportTrade", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReportTrade", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSATransactionReportTrade cSATransactionReportTrade) {
			try {
				if (areEqual(MapperS.of(cSATransactionReportTrade).<Boolean>map("getPlatformAnonymousExecutionIndicator", _cSATransactionReportTrade -> _cSATransactionReportTrade.getPlatformAnonymousExecutionIndicator()), MapperS.of(false), CardinalityOperator.All).or(notExists(MapperS.of(cSATransactionReportTrade).<Boolean>map("getPlatformAnonymousExecutionIndicator", _cSATransactionReportTrade -> _cSATransactionReportTrade.getPlatformAnonymousExecutionIndicator()))).getOrDefault(false)) {
					return exists(MapperS.of(cSATransactionReportTrade).<Boolean>map("getInterAffiliateIndicator", _cSATransactionReportTrade -> _cSATransactionReportTrade.getInterAffiliateIndicator()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSATransactionReportTradeDTCC_CSA_VR_0020_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
			return Collections.emptyList();
		}
	}
}
