package drr.regulation.csa.rewrite.valuation.reports;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ValuationDetails;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.common.ValuationTradeInformation;
import drr.regulation.common.functions.GetRegimeSpecificIdentifiers;
import drr.regulation.csa.rewrite.trade.functions.SupervisoryBodyForCSA;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(DTCC_USIIDRule.DTCC_USIIDRuleDefault.class)
public abstract class DTCC_USIIDRule implements ReportFunction<ValuationReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetRegimeSpecificIdentifiers getRegimeSpecificIdentifiers;
	@Inject protected SupervisoryBodyForCSA supervisoryBodyForCSA;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ValuationReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ValuationReportInstruction input);

	public static class DTCC_USIIDRuleDefault extends DTCC_USIIDRule {
		@Override
		protected String doEvaluate(ValuationReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ValuationReportInstruction input) {
			final MapperC<String> thenArg0 = MapperS.of(input)
				.mapSingleToList(item -> {
					if (exists(MapperC.<String>of(getRegimeSpecificIdentifiers.evaluate(item.<ReportableInformation>map("getReportableInformation", valuationReportInstruction -> valuationReportInstruction.getReportableInformation()).get(), supervisoryBodyForCSA.evaluate(), TradeIdentifierTypeEnum.UNIQUE_SWAP_IDENTIFIER))).getOrDefault(false)) {
						return MapperC.<String>of(getRegimeSpecificIdentifiers.evaluate(item.<ReportableInformation>map("getReportableInformation", valuationReportInstruction -> valuationReportInstruction.getReportableInformation()).get(), supervisoryBodyForCSA.evaluate(), TradeIdentifierTypeEnum.UNIQUE_SWAP_IDENTIFIER));
					}
					final MapperS<TradeIdentifier> _thenArg0 = item
						.mapSingleToItem(_item -> _item.<ValuationDetails>map("getValuationDetails", valuationReportInstruction -> valuationReportInstruction.getValuationDetails()).<ValuationTradeInformation>map("getTradeInformation", valuationDetails -> valuationDetails.getTradeInformation()).<TradeIdentifier>map("getUniqueTradeIdentifier", valuationTradeInformation -> valuationTradeInformation.getUniqueTradeIdentifier()));
					final MapperS<TradeIdentifier> _thenArg1 = _thenArg0
						.filterSingleNullSafe(_item -> areEqual(_item.<TradeIdentifierTypeEnum>map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), MapperS.of(TradeIdentifierTypeEnum.UNIQUE_SWAP_IDENTIFIER), CardinalityOperator.All).get());
					return _thenArg1
						.mapSingleToList(_item -> _item.<AssignedIdentifier>mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).<FieldWithMetaString>map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier())).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
				});
			final MapperC<String> thenArg1 = distinct(thenArg0);
			output = MapperS.of(thenArg1.get()).get();
			
			return output;
		}
	}
}
