package drr.regulation.esma.emir.refit.trade.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class ESMAEMIRTradeLabelProvider extends GraphBasedLabelProvider {
	public ESMAEMIRTradeLabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("effectiveDate"), "2.43 Effective Date");
		startNode.addLabel(Arrays.asList("earlyTerminationDate"), "2.45 Early termination date");
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "1.1 Reporting Timestamp");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "2.42 Execution Timestamp");
		startNode.addLabel(Arrays.asList("expirationDate"), "2.44 Expiration Date");
		startNode.addLabel(Arrays.asList("counterparty1"), "1.4 Counterparty 1 (reporting counterparty)");
		startNode.addLabel(Arrays.asList("counterparty2"), "1.9 Counterparty 2");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierType"), "1.8 Counterparty 2 Identifier Type");
		startNode.addLabel(Arrays.asList("cleared"), "2.31 Cleared");
		startNode.addLabel(Arrays.asList("centralCounterparty"), "2.33 Central Counterparty");
		startNode.addLabel(Arrays.asList("clearingMember"), "1.16 Clearing member");
		startNode.addLabel(Arrays.asList("confirmed"), "2.29 Confirmed");
		startNode.addLabel(Arrays.asList("delta"), "2.25 Delta");
		startNode.addLabel(Arrays.asList("priceSchedule", "effectiveDate"), "2.50/2.52-$ 2.50 Unadjusted effective date of the price");
		startNode.addLabel(Arrays.asList("priceSchedule", "endDate"), "2.50/2.52-$ 2.51 Unadjusted end date of the price");
		startNode.addLabel(Arrays.asList("priceSchedule", "price", "monetary"), "2.50/2.52-$ 2.52 Price in effect between the unadjusted effective and end date (Monetary)");
		startNode.addLabel(Arrays.asList("priceSchedule", "price", "percentage"), "2.50/2.52-$ 2.52 Price in effect between the unadjusted effective and end date (Percentage)");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "effectiveDate"), "2.135/2.137-$ 2.135 Effective date of the strike price");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "endDate"), "2.135/2.137-$ 2.136 End date of the strike price");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "price", "monetary"), "2.135/2.137-$ 2.137 Strike price in effect on associated effective date (Monetary)");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "price", "percentage"), "2.135/2.137-$ 2.137 Strike price in effect on associated effective date (Percentage)");
		startNode.addLabel(Arrays.asList("price", "monetary"), "2.48 Price (Monetary)");
		startNode.addLabel(Arrays.asList("price", "percentage"), "2.48 Price (Percentage)");
		startNode.addLabel(Arrays.asList("price", "basis"), "2.48 Price (Basis)");
		startNode.addLabel(Arrays.asList("priceNotation"), "2.48 Price Notation (Non Reportable)");
		startNode.addLabel(Arrays.asList("priceCurrency"), "2.49 Price Currency");
		startNode.addLabel(Arrays.asList("packageTransactionPrice", "monetary"), "2.53 Package Transaction Price (Monetary)");
		startNode.addLabel(Arrays.asList("packageTransactionPrice", "percentage"), "2.53 Package Transaction Price (Percentage)");
		startNode.addLabel(Arrays.asList("packageTransactionPrice", "basis"), "2.53 Package Transaction Price (Basis)");
		startNode.addLabel(Arrays.asList("packageTransactionPriceNotation"), "2.53 Package Transaction Price Notation");
		startNode.addLabel(Arrays.asList("packageTransactionPriceCurrency"), "2.54 Package Transaction Price Currency");
		startNode.addLabel(Arrays.asList("packageTransactionSpread", "monetary"), "2.111 Package transaction spread (Monetary)");
		startNode.addLabel(Arrays.asList("packageTransactionSpread", "percentage"), "2.111 Package transaction spread (Percentage)");
		startNode.addLabel(Arrays.asList("packageTransactionSpread", "basis"), "2.111 Package transaction spread (Basis)");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadNotation"), "2.111 Package transaction spread Notation (Non Reportable)");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadCurrency"), "2.112 Package transaction spread currency");
		startNode.addLabel(Arrays.asList("packageIdentifier"), "2.6 Package identifier");
		startNode.addLabel(Arrays.asList("strikePrice", "monetary"), "2.134 Strike Price (Monetary)");
		startNode.addLabel(Arrays.asList("strikePrice", "percentage"), "2.134 Strike Price (Percentage)");
		startNode.addLabel(Arrays.asList("strikePriceNotation"), "2.134 Strike Price Notation (Non Reportable)");
		startNode.addLabel(Arrays.asList("strikePriceCurrency"), "2.138 Strike price currency/currency pair");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "2.139 Option Premium Amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "2.140 Option Premium Currency");
		startNode.addLabel(Arrays.asList("optionPremiumPaymentDate"), "2.141 Option Premium Payment Date");
		startNode.addLabel(Arrays.asList("exchangeRate"), "2.113 Exchange Rate 1");
		startNode.addLabel(Arrays.asList("exchangeRateBasis"), "2.115 Exchange Rate Basis");
		startNode.addLabel(Arrays.asList("cdSIndexAttachmentPoint"), "2.149 CDS Index Attachment Point");
		startNode.addLabel(Arrays.asList("cdSIndexDetachmentPoint"), "2.150 CDS Index Detachment Point");
		startNode.addLabel(Arrays.asList("collateralPortfolioIndicator"), "2.26 Collateral Portfolio Indicator");
		startNode.addLabel(Arrays.asList("finalContractualSettlementDate"), "2.46 Final Contractual Settlement Date");
		startNode.addLabel(Arrays.asList("priorUTI"), "2.3 Prior UTI");
		startNode.addLabel(Arrays.asList("direction1"), "1.17 Direction");
		startNode.addLabel(Arrays.asList("valuationAmount"), "2.21 Valuation amount");
		startNode.addLabel(Arrays.asList("valuationCurrency"), "2.22 Valuation currency");
		startNode.addLabel(Arrays.asList("valuationMethod"), "2.24 Valuation method");
		startNode.addLabel(Arrays.asList("valuationTimestamp"), "2.23 Valuation Timestamp");
		startNode.addLabel(Arrays.asList("customBasketCode"), "2.17 Custom basket code");
		startNode.addLabel(Arrays.asList("basketConstituents", "identifier"), "2.18 Identifier of the basket's constituents");
		startNode.addLabel(Arrays.asList("otherPayment", "paymentType"), "2.73/2.78-$ 2.73 Other Payment Type");
		startNode.addLabel(Arrays.asList("otherPayment", "amount"), "2.73/2.78-$ 2.74 Other Payment Amount");
		startNode.addLabel(Arrays.asList("otherPayment", "currency"), "2.73/2.78-$ 2.75 Other Payment Currency");
		startNode.addLabel(Arrays.asList("otherPayment", "date"), "2.73/2.78-$ 2.76 Other Payment Date");
		startNode.addLabel(Arrays.asList("otherPayment", "payer"), "2.73/2.78-$ 2.77 Other Payment Payer");
		startNode.addLabel(Arrays.asList("otherPayment", "payerFormat"), "2.73/2.78-$ 2.77 Other Payment Payer Format (non-reportable)");
		startNode.addLabel(Arrays.asList("otherPayment", "receiver"), "2.73/2.78-$ 2.78 Other Payment Receiver");
		startNode.addLabel(Arrays.asList("otherPayment", "receiverFormat"), "2.73/2.78-$ 2.78 Other Payment Receiver Format (non-reportable)");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmount"), "2.55 Notional Amount 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalCurrency"), "2.56 Notional Currency 1");
		startNode.addLabel(Arrays.asList("leg1", "totalNotionalQuantity"), "2.60 Total notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "settlementCurrency"), "2.19 Settlement Currency 1");
		startNode.addLabel(Arrays.asList("leg1", "fixedRate"), "2.79 Fixed Rate of leg 1 or coupon");
		startNode.addLabel(Arrays.asList("leg1", "spread", "monetary"), "2.93 Spread of Leg 1 (Monetary)");
		startNode.addLabel(Arrays.asList("leg1", "spread", "percentage"), "2.93 Spread of Leg 1 (Percentage)");
		startNode.addLabel(Arrays.asList("leg1", "spread", "basis"), "2.93 Spread of Leg 1 (Basis)");
		startNode.addLabel(Arrays.asList("leg1", "spreadNotation"), "2.93 Spread of Leg 1 Notation (Non Reportable)");
		startNode.addLabel(Arrays.asList("leg1", "spreadCurrency"), "2.94 Spread Currency of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "effectiveDate"), "2.61/2.63-$ 2.61 Effective date of the notional quantity of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "endDate"), "2.61/2.63-$ 2.62 End date of the notional quantity of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "value"), "2.61/2.63-$ 2.63 Notional quantity in effect on associated effective date of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "effectiveDate"), "2.57/2.59-$ 2.57 Effective date of the notional amount of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "endDate"), "2.57/2.59-$ 2.58 End date of the notional amount of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "value"), "2.57/2.59-$ 2.59 Notional amount in effect on associated effective date of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "direction2"), "1.18 Direction of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRateDayCountConvention"), "2.80 Fixed rate or coupon day count convention leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "2.81 Fixed rate or coupon payment frequency period leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "2.82 Fixed rate or coupon payment frequency period multiplier leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateIdentifier"), "2.83 - Identifier of the floating rate of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateIndicator"), "2.84 Indicator of the floating rate of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "nameOfTheFloatingRate"), "2.85 Name of the Floating Rate of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateDayCountConvention"), "2.86 Floating rate day count convention of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "2.87 Floating rate payment frequency period of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "2.88 Floating rate payment frequency period multiplier of leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateReferencePeriod"), "2.89 Floating rate reference period of leg 1 - time period");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateReferencePeriodMultiplier"), "2.90 Floating rate reference period of leg 1 - multiplier");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyPeriod"), "2.91 Floating rate reset frequency period of Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "2.92 Floating rate reset frequency multiplier of leg 1");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmount"), "2.64 Notional Amount 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalCurrency"), "2.65 Notional Currency 2");
		startNode.addLabel(Arrays.asList("leg2", "totalNotionalQuantity"), "2.69 Total notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "settlementCurrency"), "2.20 Settlement Currency 2");
		startNode.addLabel(Arrays.asList("leg2", "fixedRate"), "2.95 Fixed Rate of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "monetary"), "2.109 Spread of Leg 2 (Monetary)");
		startNode.addLabel(Arrays.asList("leg2", "spread", "percentage"), "2.109 Spread of Leg 2 (Percentage)");
		startNode.addLabel(Arrays.asList("leg2", "spread", "basis"), "2.109 Spread of Leg 2 (Basis)");
		startNode.addLabel(Arrays.asList("leg2", "spreadNotation"), "2.109 Spread of Leg 2 Notation (Non Reportable)");
		startNode.addLabel(Arrays.asList("leg2", "spreadCurrency"), "2.110 Spread Currency of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "effectiveDate"), "2.66/2.68-$ 2.66 Effective date of the notional amount of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "endDate"), "2.66/2.68-$ 2.67 End date of the notional amount of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "value"), "2.66/2.68-$ 2.68 Notional amount in effect on associated effective date of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "effectiveDate"), "2.70/2.72-$ 2.70 Effective date of the notional quantity of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "endDate"), "2.70/2.72-$ 2.71 End date of the notional quantity of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "value"), "2.70/2.72-$ 2.72 Notional quantity in effect on associated effective date of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "direction2"), "1.19 Direction of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRateDayCountConvention"), "2.96 Fixed rate day count convention leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "2.97 Fixed rate payment frequency period leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "2.98 Fixed rate payment frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateIdentifier"), "2.99 - Identifier of the floating rate of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateIndicator"), "2.100 Indicator of the floating rate of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "nameOfTheFloatingRate"), "2.101 Name of the Floating Rate of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateDayCountConvention"), "2.102 Floating rate day count convention of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "2.103 Floating rate payment frequency period of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "2.104 Floating rate payment frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateReferencePeriod"), "2.105 Floating rate reference period of leg 2 - time period");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateReferencePeriodMultiplier"), "2.106 Floating rate reference period of leg 2 - multiplier");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyPeriod"), "2.107 Floating rate reset frequency period of Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "2.108 Floating rate reset frequency multiplier of leg 2");
		startNode.addLabel(Arrays.asList("cryptoAssetUnderlyingIndicator"), "2.12 Derivative based on crypto-assets");
		startNode.addLabel(Arrays.asList("level"), "2.154 Level");
		startNode.addLabel(Arrays.asList("actionType"), "2.151 Action type");
		startNode.addLabel(Arrays.asList("eventType"), "2.152 Event Type");
		startNode.addLabel(Arrays.asList("reportSubmittingEntityID"), "1.2 Report Submitting entity ID");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifier"), "2.1 UTI");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifierProprietary"), "2.1 UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("priorUTIProprietary"), "2.3 Prior UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("uniqueProductIdentifier"), "2.8 UPI");
		startNode.addLabel(Arrays.asList("contractType"), "2.10 Contract Type");
		startNode.addLabel(Arrays.asList("assetClass"), "2.11 Asset Class");
		startNode.addLabel(Arrays.asList("clearingTimestamp"), "2.32 Clearing Timestamp");
		startNode.addLabel(Arrays.asList("nameOfTheUnderlyingIndex"), "2.16 Name of the underlying index");
		startNode.addLabel(Arrays.asList("maturityDateOfTheUnderlying"), "2.142 Maturity date of the underlying");
		startNode.addLabel(Arrays.asList("optionType"), "2.132 Option type");
		startNode.addLabel(Arrays.asList("optionStyle"), "2.133 Option Style");
		startNode.addLabel(Arrays.asList("deliveryType"), "2.47 Delivery Type");
		startNode.addLabel(Arrays.asList("countryOfTheCounterparty2"), "1.10 Country of the counterparty 2");
		startNode.addLabel(Arrays.asList("seniority"), "2.143 Seniority");
		startNode.addLabel(Arrays.asList("series"), "2.145 Series");
		startNode.addLabel(Arrays.asList("indexFactor"), "2.147 Index factor");
		startNode.addLabel(Arrays.asList("subsequentPositionUTI"), "2.4 Subsequent Position UTI");
		startNode.addLabel(Arrays.asList("masterAgreementType"), "2.34 Master Agreement Type");
		startNode.addLabel(Arrays.asList("masterAgreementVersion"), "2.36 Master Agreement version");
		startNode.addLabel(Arrays.asList("brokerID"), "1.15 Broker ID");
		startNode.addLabel(Arrays.asList("confirmationTimestamp"), "2.28 Confirmation Timestamp");
		startNode.addLabel(Arrays.asList("seriesVersion"), "2.146 Version");
		startNode.addLabel(Arrays.asList("natureOfCounterparty1"), "1.5 Nature of the Counterparty 1");
		startNode.addLabel(Arrays.asList("natureOfCounterparty2"), "1.11 Nature of the Counterparty 2");
		startNode.addLabel(Arrays.asList("baseProduct"), "2.116 Base Product");
		startNode.addLabel(Arrays.asList("subProduct"), "2.117 Sub Product");
		startNode.addLabel(Arrays.asList("furtherSubProduct"), "2.118 Further sub-product");
		startNode.addLabel(Arrays.asList("intragroup"), "2.37 Intragroup");
		startNode.addLabel(Arrays.asList("entityResponsibleForReporting"), "1.3 Entity responsible for reporting");
		startNode.addLabel(Arrays.asList("referenceEntity"), "2.144 Reference Entity");
		startNode.addLabel(Arrays.asList("underlyingIdentification"), "2.14 Underlying Identification");
		startNode.addLabel(Arrays.asList("underlyingIdentificationType"), "2.13 Underlying Identification Type");
		startNode.addLabel(Arrays.asList("corporateSectorOfTheCounterparty1"), "1.6 Corporate sector of the counterparty 1");
		startNode.addLabel(Arrays.asList("corporateSectorOfTheCounterparty2"), "1.12 Corporate sector of the counterparty 2");
		startNode.addLabel(Arrays.asList("nonReportable", "enrichment"), "Enrichment Data");
		startNode.addLabel(Arrays.asList("nonReportable", "preUpiData"), "Upi Pre-Enrichment Data");
		startNode.addLabel(Arrays.asList("nonReportable", "postUpiData"), "Upi Post-Enrichment Data");
		startNode.addLabel(Arrays.asList("otherMasterAgreementType"), "2.35 Other Master Agreement Type");
		startNode.addLabel(Arrays.asList("collateralPortfolioCode"), "2.27 Collateral Portfolio Code");
		startNode.addLabel(Arrays.asList("ptrrId"), "2.5 PTRR ID");
		startNode.addLabel(Arrays.asList("clearingThresholdOfCounterparty1"), "1.7 Clearing Threshold of Counterparty 1");
		startNode.addLabel(Arrays.asList("clearingThresholdOfCounterparty2"), "1.13 Clearing Threshold of Counterparty 2");
		startNode.addLabel(Arrays.asList("reportingObligationOfTheCounterparty2"), "1.14 Reporting obligation of the counterparty 2");
		startNode.addLabel(Arrays.asList("directlyLinkedToCommercialActivityOrTreasuryFinancing"), "1.20 Directly linked to commercial activity or treasury financing");
		startNode.addLabel(Arrays.asList("reportTrackingNumber"), "2.2 Report Tracking Number");
		startNode.addLabel(Arrays.asList("isin"), "2.7 ISIN");
		startNode.addLabel(Arrays.asList("productClassification"), "2.9 Product classification");
		startNode.addLabel(Arrays.asList("indicatorOfTheUnderlyingIndex"), "2.15 Indicator of the underlying index");
		startNode.addLabel(Arrays.asList("clearingObligation"), "2.30 Clearing Obligation");
		startNode.addLabel(Arrays.asList("ptrr"), "2.38 PTRR");
		startNode.addLabel(Arrays.asList("typeOfPTRRTechnique"), "2.39 Type of PTRR technique");
		startNode.addLabel(Arrays.asList("ptrrServiceProvider"), "2.40 PTRR service provider");
		startNode.addLabel(Arrays.asList("venueOfExecution"), "2.41 Venue of Execution");
		startNode.addLabel(Arrays.asList("forwardExchangeRate"), "2.114 Forward exchange rate");
		startNode.addLabel(Arrays.asList("deliveryPoint"), "2.119 Delivery point or zone");
		startNode.addLabel(Arrays.asList("interconnectionPoint"), "2.120 Interconnection Point");
		startNode.addLabel(Arrays.asList("loadType"), "2.121 Load type");
		startNode.addLabel(Arrays.asList("deliveryReport", "deliveryStartTime"), "2.122/2.131-$ 2.123 Delivery interval end time");
		startNode.addLabel(Arrays.asList("deliveryReport", "deliveryStartDate"), "2.122/2.131-$ 2.124 Delivery start date");
		startNode.addLabel(Arrays.asList("deliveryReport", "deliveryEndDate"), "2.122/2.131-$ 2.125 Delivery end date");
		startNode.addLabel(Arrays.asList("deliveryReport", "duration"), "2.122/2.131-$ 2.126 Duration");
		startNode.addLabel(Arrays.asList("deliveryReport", "daysOfTheWeek"), "2.122/2.131-$ 2.127 Days of the week");
		startNode.addLabel(Arrays.asList("deliveryReport", "deliveryCapacity"), "2.122/2.131-$ 2.128 Delivery capacity");
		startNode.addLabel(Arrays.asList("deliveryReport", "quantityUnit"), "2.122/2.131-$ 2.129 Quantity unit");
		startNode.addLabel(Arrays.asList("deliveryReport", "priceTimeIntervalQuantity"), "2.122/2.131-$ 2.130 Price time interval quantity");
		startNode.addLabel(Arrays.asList("deliveryReport", "currencyOfThePriceTimeIntervalQuantity"), "2.122/2.131-$ 2.131 Currency of the price time interval quantity");
		startNode.addLabel(Arrays.asList("tranche"), "2.148 Tranche");
		startNode.addLabel(Arrays.asList("eventDate"), "2.153 Event Date");
	}
}
