package drr.regulation.fca.ukemir.refit.valuation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.emir.functions.ValuationTimestamp_04_Validation;
import drr.regulation.fca.ukemir.refit.valuation.FCAValuationReport;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 7.0.0-dev.52
 */
@RosettaDataRule("FCAValuationReportUKEMIR_VR_2023_04")
@ImplementedBy(FCAValuationReportUKEMIR_VR_2023_04.Default.class)
public interface FCAValuationReportUKEMIR_VR_2023_04 extends Validator<FCAValuationReport> {
	
	String NAME = "FCAValuationReportUKEMIR_VR_2023_04";
	String DEFINITION = "ValuationTimestamp_04_Validation( valuationAmount, valuationTimestamp, reportingTimestamp )";
	
	class Default implements FCAValuationReportUKEMIR_VR_2023_04 {
	
		@Inject protected ValuationTimestamp_04_Validation valuationTimestamp_04_Validation;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAValuationReport fCAValuationReport) {
			ComparisonResult result = executeDataRule(fCAValuationReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAValuationReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAValuationReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAValuationReport fCAValuationReport) {
			try {
				return ComparisonResult.of(MapperS.of(valuationTimestamp_04_Validation.evaluate(MapperS.of(fCAValuationReport).<BigDecimal>map("getValuationAmount", _fCAValuationReport -> _fCAValuationReport.getValuationAmount()).get(), MapperS.of(fCAValuationReport).<ZonedDateTime>map("getValuationTimestamp", _fCAValuationReport -> _fCAValuationReport.getValuationTimestamp()).get(), MapperS.of(fCAValuationReport).<ZonedDateTime>map("getReportingTimestamp", _fCAValuationReport -> _fCAValuationReport.getReportingTimestamp()).get())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAValuationReportUKEMIR_VR_2023_04 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAValuationReport fCAValuationReport) {
			return Collections.emptyList();
		}
	}
}
