package drr.regulation.hkma.rewrite.trade.functions;

import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.TradeForEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.TransactionReportInstruction;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Extract_UTIPropietary.Extract_UTIPropietaryDefault.class)
public abstract class Extract_UTIPropietary implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return tradeIdentifier 
	*/
	public TradeIdentifier evaluate(TransactionReportInstruction reportableEvent) {
		TradeIdentifier.TradeIdentifierBuilder tradeIdentifierBuilder = doEvaluate(reportableEvent);
		
		final TradeIdentifier tradeIdentifier;
		if (tradeIdentifierBuilder == null) {
			tradeIdentifier = null;
		} else {
			tradeIdentifier = tradeIdentifierBuilder.build();
			objectValidator.validate(TradeIdentifier.class, tradeIdentifier);
		}
		
		return tradeIdentifier;
	}

	protected abstract TradeIdentifier.TradeIdentifierBuilder doEvaluate(TransactionReportInstruction reportableEvent);

	public static class Extract_UTIPropietaryDefault extends Extract_UTIPropietary {
		@Override
		protected TradeIdentifier.TradeIdentifierBuilder doEvaluate(TransactionReportInstruction reportableEvent) {
			TradeIdentifier.TradeIdentifierBuilder tradeIdentifier = TradeIdentifier.builder();
			return assignOutput(tradeIdentifier, reportableEvent);
		}
		
		protected TradeIdentifier.TradeIdentifierBuilder assignOutput(TradeIdentifier.TradeIdentifierBuilder tradeIdentifier, TransactionReportInstruction reportableEvent) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(reportableEvent);
			final MapperC<TradeIdentifier> thenArg1 = thenArg0
				.mapSingleToList(item -> {
					if (exists(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation())).getOrDefault(false)) {
						return item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()).<TradeIdentifier>map("getTransactionIdentifier", transactionInformation -> transactionInformation.getTransactionIdentifier());
					}
					if (exists(MapperS.of(tradeForEvent.evaluate(item.get()))).getOrDefault(false)) {
						return MapperS.of(tradeForEvent.evaluate(item.get())).<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier());
					}
					return MapperC.<TradeIdentifier>ofNull();
				});
			final MapperC<TradeIdentifier> thenArg2 = distinct(thenArg1);
			tradeIdentifier = toBuilder(MapperS.of(thenArg2.get()).get());
			
			return Optional.ofNullable(tradeIdentifier)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
