package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReferenceEntityFormatEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.hkma.rewrite.trade.functions.Extract_ReferenceEntityFormat;
import javax.inject.Inject;


@ImplementedBy(ReferenceEntityFormatRule.ReferenceEntityFormatRuleDefault.class)
public abstract class ReferenceEntityFormatRule implements ReportFunction<TransactionReportInstruction, ReferenceEntityFormatEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Extract_ReferenceEntityFormat extract_ReferenceEntityFormat;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ReferenceEntityFormatEnum evaluate(TransactionReportInstruction input) {
		ReferenceEntityFormatEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ReferenceEntityFormatEnum doEvaluate(TransactionReportInstruction input);

	public static class ReferenceEntityFormatRuleDefault extends ReferenceEntityFormatRule {
		@Override
		protected ReferenceEntityFormatEnum doEvaluate(TransactionReportInstruction input) {
			ReferenceEntityFormatEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ReferenceEntityFormatEnum assignOutput(ReferenceEntityFormatEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(extract_ReferenceEntityFormat.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
