package drr.regulation.jfsa.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.jfsa.rewrite.margin.JFSAMarginReport;
import drr.regulation.jfsa.rewrite.margin.labels.JFSAMarginLabelProvider;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.jfsa.rewrite.margin", body="JFSA", corpusList={"Margin"})
@RuneLabelProvider(labelProvider=JFSAMarginLabelProvider.class)
@ImplementedBy(JFSAMarginReportFunction.JFSAMarginReportFunctionDefault.class)
public abstract class JFSAMarginReportFunction implements ReportFunction<CollateralReportInstruction, JFSAMarginReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected CollateralisationCategoryRule collateralisationCategoryRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CurrencyOfExcessCollateralCollectedRule currencyOfExcessCollateralCollectedRule;
	@Inject protected CurrencyOfTheExcessCollateralPostedRule currencyOfTheExcessCollateralPostedRule;
	@Inject protected CurrencyOfVariationMarginCollectedRule currencyOfVariationMarginCollectedRule;
	@Inject protected CurrencyOfVariationMarginPostedRule currencyOfVariationMarginPostedRule;
	@Inject protected CurrencyofInitialMarginCollectedRule currencyofInitialMarginCollectedRule;
	@Inject protected CurrencyofInitialMarginPostedRule currencyofInitialMarginPostedRule;
	@Inject protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected ExcessCollateralCollectedByTheReportingCounterpartyRule excessCollateralCollectedByTheReportingCounterpartyRule;
	@Inject protected ExcessCollateralPostedByTheReportingCounterpartyRule excessCollateralPostedByTheReportingCounterpartyRule;
	@Inject protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
	@Inject protected InitialMarginCollectedByReportingCounterpartyPostHaircutRule initialMarginCollectedByReportingCounterpartyPostHaircutRule;
	@Inject protected InitialMarginCollectedByReportingCounterpartyPreHaircutRule initialMarginCollectedByReportingCounterpartyPreHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingCounterpartyPostHaircutRule initialMarginPostedByTheReportingCounterpartyPostHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingCounterpartyPreHaircutRule initialMarginPostedByTheReportingCounterpartyPreHaircutRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SubmitterIdentifierRule submitterIdentifierRule;
	@Inject protected TechnicalRecordIdRule technicalRecordIdRule;
	@Inject protected UTIRule uTIRule;
	@Inject protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
	@Inject protected VariationMarginCollectedByTheReportingCounterpartyPostHaircutRule variationMarginCollectedByTheReportingCounterpartyPostHaircutRule;
	@Inject protected VariationMarginCollectedByTheReportingCounterpartyPreHaircutRule variationMarginCollectedByTheReportingCounterpartyPreHaircutRule;
	@Inject protected VariationMarginPostedByTheReportingCounterpartyPostHaircutRule variationMarginPostedByTheReportingCounterpartyPostHaircutRule;
	@Inject protected VariationMarginPostedByTheReportingCounterpartyPreHaircutRule variationMarginPostedByTheReportingCounterpartyPreHaircutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public JFSAMarginReport evaluate(CollateralReportInstruction input) {
		JFSAMarginReport.JFSAMarginReportBuilder outputBuilder = doEvaluate(input);
		
		final JFSAMarginReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(JFSAMarginReport.class, output);
		}
		
		return output;
	}

	protected abstract JFSAMarginReport.JFSAMarginReportBuilder doEvaluate(CollateralReportInstruction input);

	public static class JFSAMarginReportFunctionDefault extends JFSAMarginReportFunction {
		@Override
		protected JFSAMarginReport.JFSAMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
			JFSAMarginReport.JFSAMarginReportBuilder output = JFSAMarginReport.builder();
			return assignOutput(output, input);
		}
		
		protected JFSAMarginReport.JFSAMarginReportBuilder assignOutput(JFSAMarginReport.JFSAMarginReportBuilder output, CollateralReportInstruction input) {
			output
				.getOrCreatePartiesToTheDerivative()
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setSubmitterIdentifier(submitterIdentifierRule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setEntityResponsibleForReporting(entityResponsibleForReportingRule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeRule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setUti(uTIRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCollateralisationCategory(collateralisationCategoryRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginPostedByTheReportingCounterpartyPreHaircut(initialMarginPostedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginPostedByTheReportingCounterpartyPostHaircut(initialMarginPostedByTheReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCurrencyofInitialMarginPosted(currencyofInitialMarginPostedRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginCollectedByReportingCounterpartyPreHaircut(initialMarginCollectedByReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginCollectedByReportingCounterpartyPostHaircut(initialMarginCollectedByReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCurrencyofInitialMarginCollected(currencyofInitialMarginCollectedRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginPostedByTheReportingCounterpartyPreHaircut(variationMarginPostedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginPostedByTheReportingCounterpartyPostHaircut(variationMarginPostedByTheReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCurrencyOfVariationMarginPosted(currencyOfVariationMarginPostedRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(variationMarginCollectedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginCollectedByTheReportingCounterpartyPostHaircut(variationMarginCollectedByTheReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCurrencyOfVariationMarginCollected(currencyOfVariationMarginCollectedRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setExcessCollateralPostedByTheReportingCounterparty(excessCollateralPostedByTheReportingCounterpartyRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCurrencyOfTheExcessCollateralPosted(currencyOfTheExcessCollateralPostedRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setExcessCollateralCollectedByTheReportingCounterparty(excessCollateralCollectedByTheReportingCounterpartyRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCurrencyOfTheExcessCollateralCollected(currencyOfExcessCollateralCollectedRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setTechnicalRecordId(technicalRecordIdRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
