package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg2Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.functions.FloatingInterestRatePayoutFromPayout;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierRule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodRule;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iosco.cde.version3.functions.Leg2;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleRule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleRule;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Leg2ReportRule.Leg2ReportRuleDefault.class)
public abstract class Leg2ReportRule implements ReportFunction<TransactionReportInstruction, CommonLeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected FixingDateLeg2Rule fixingDateLeg2Rule;
	@Inject protected FloatingInterestRatePayoutFromPayout floatingInterestRatePayoutFromPayout;
	@Inject protected FloatingRateIndicatorLeg2Rule floatingRateIndicatorLeg2Rule;
	@Inject protected FloatingRateReferencePeriodLeg2Rule floatingRateReferencePeriodLeg2Rule;
	@Inject protected FloatingRateReferencePeriodMultiplierLeg2Rule floatingRateReferencePeriodMultiplierLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierRule floatingRateResetFrequencyPeriodMultiplierRule;
	@Inject protected FloatingRateResetFrequencyPeriodRule floatingRateResetFrequencyPeriodRule;
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected Leg2 leg2;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NameOfTheFloatingRateLeg2Rule nameOfTheFloatingRateLeg2Rule;
	@Inject protected NotionalAmountScheduleRule notionalAmountScheduleRule;
	@Inject protected NotionalQuantityScheduleRule notionalQuantityScheduleRule;
	@Inject protected PayoutLeg2Rule payoutLeg2Rule;
	@Inject protected SpreadNotationOfLeg2Rule spreadNotationOfLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CommonLeg evaluate(TransactionReportInstruction input) {
		CommonLeg.CommonLegBuilder outputBuilder = doEvaluate(input);
		
		final CommonLeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CommonLeg.class, output);
		}
		
		return output;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg2ReportRuleDefault extends Leg2ReportRule {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
			CommonLeg.CommonLegBuilder output = CommonLeg.builder();
			return assignOutput(output, input);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
			final BigDecimal bigDecimal0 = floatingRateResetFrequencyPeriodMultiplierRule.evaluate(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg2Rule.evaluate(thenArg.get())));
			final BigDecimal bigDecimal1 = floatingRateReferencePeriodMultiplierLeg2Rule.evaluate(thenArg.get());
			output = toBuilder(MapperS.of(legEnrichment.evaluate(leg2.evaluate(thenArg.get(), spreadNotationOfLeg2Rule.evaluate(thenArg.get()), (bigInteger == null ? null : new BigDecimal(bigInteger))), notionalAmountScheduleRule.evaluate(payoutLeg2Rule.evaluate(thenArg.get())), notionalQuantityScheduleRule.evaluate(payoutLeg2Rule.evaluate(thenArg.get())), null, floatingRateResetFrequencyPeriodRule.evaluate(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg2Rule.evaluate(thenArg.get()))), (bigDecimal0 == null ? null : bigDecimal0.intValueExact()), fixingDateLeg2Rule.evaluate(thenArg.get()), null, null, floatingRateIndicatorLeg2Rule.evaluate(thenArg.get()), null, floatingRateReferencePeriodLeg2Rule.evaluate(thenArg.get()), (bigDecimal1 == null ? null : bigDecimal1.intValueExact()), nameOfTheFloatingRateLeg2Rule.evaluate(thenArg.get()))).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
