package drr.regulation.mas.rewrite.trade.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.functions.FloatingInterestRatePayoutFromPayout;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierRule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodRule;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg1;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg1Rule;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.version3.functions.Leg1;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleRule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleRule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Leg1ReportRule.Leg1ReportRuleDefault.class)
public abstract class Leg1ReportRule implements ReportFunction<TransactionReportInstruction, CommonLeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected FloatingInterestRatePayoutFromPayout floatingInterestRatePayoutFromPayout;
	@Inject protected FloatingRateIdentifierLeg1Rule floatingRateIdentifierLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierRule floatingRateResetFrequencyPeriodMultiplierRule;
	@Inject protected FloatingRateResetFrequencyPeriodRule floatingRateResetFrequencyPeriodRule;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected Leg1 leg1;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NameOfTheFloatingRateLeg1Rule nameOfTheFloatingRateLeg1Rule;
	@Inject protected NotionalAmountScheduleRule notionalAmountScheduleRule;
	@Inject protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
	@Inject protected NotionalQuantityScheduleRule notionalQuantityScheduleRule;
	@Inject protected PayoutLeg1Rule payoutLeg1Rule;
	@Inject protected QuantityFrequencyLeg1 quantityFrequencyLeg1;
	@Inject protected SpreadNotationOfLeg1Rule spreadNotationOfLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CommonLeg evaluate(TransactionReportInstruction input) {
		CommonLeg.CommonLegBuilder outputBuilder = doEvaluate(input);
		
		final CommonLeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CommonLeg.class, output);
		}
		
		return output;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg1ReportRuleDefault extends Leg1ReportRule {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
			CommonLeg.CommonLegBuilder output = CommonLeg.builder();
			return assignOutput(output, input);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForMAS.evaluate(item.get()));
			final MapperS<CommonLeg> ifThenElseResult;
			if (exists(thenArg0).getOrDefault(false)) {
				final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
				final MapperS<InterestRatePayout> thenArg1 = MapperS.of(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(thenArg0.get())));
				final MapperS<InterestRatePayout> thenArg2 = MapperS.of(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(thenArg0.get())));
				final BigDecimal bigDecimal = MapperS.of(floatingRateResetFrequencyPeriodMultiplierRule.evaluate(thenArg2.get())).get();
				ifThenElseResult = MapperS.of(legEnrichment.evaluate(leg1.evaluate(thenArg0.get(), spreadNotationOfLeg1Rule.evaluate(thenArg0.get()), (bigInteger == null ? null : new BigDecimal(bigInteger))), notionalAmountScheduleRule.evaluate(payoutLeg1Rule.evaluate(thenArg0.get())), notionalQuantityScheduleRule.evaluate(payoutLeg1Rule.evaluate(thenArg0.get())), notionalQuantityLeg1Rule.evaluate(thenArg0.get()), MapperS.of(floatingRateResetFrequencyPeriodRule.evaluate(thenArg1.get())).get(), (bigDecimal == null ? null : bigDecimal.intValueExact()), null, MapperS.of(quantityFrequencyLeg1.evaluate(thenArg0.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get(), MapperS.of(quantityFrequencyLeg1.evaluate(thenArg0.get())).<Integer>map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), null, floatingRateIdentifierLeg1Rule.evaluate(thenArg0.get()), null, null, nameOfTheFloatingRateLeg1Rule.evaluate(thenArg0.get())));
			} else {
				ifThenElseResult = MapperS.<CommonLeg>ofNull();
			}
			output = toBuilder(ifThenElseResult.get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
