package drr.regulation.sec.rewrite.dtcc.reports;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import javax.inject.Inject;


@ImplementedBy(DTCC_UnderlyingAssetIDTypeRule.DTCC_UnderlyingAssetIDTypeRuleDefault.class)
public abstract class DTCC_UnderlyingAssetIDTypeRule implements ReportFunction<ProductIdentifier, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.dtcc.reports.DTCC_UnderlyingAssetIDTypeRule dTCC_UnderlyingAssetIDTypeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ProductIdentifier input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ProductIdentifier input);

	public static class DTCC_UnderlyingAssetIDTypeRuleDefault extends DTCC_UnderlyingAssetIDTypeRule {
		@Override
		protected String doEvaluate(ProductIdentifier input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ProductIdentifier input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(dTCC_UnderlyingAssetIDTypeRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
