package drr.regulation.sec.rewrite.dtcc.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.dtcc.UnderlyingAssetNameReport;
import drr.regulation.sec.rewrite.trade.functions.IsAllowableActionForSEC;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(DTCC_UnderlyingAssetNameRule.DTCC_UnderlyingAssetNameRuleDefault.class)
public abstract class DTCC_UnderlyingAssetNameRule implements ReportFunction<TransactionReportInstruction, UnderlyingAssetNameReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.dtcc.reports.DTCC_UnderlyingAssetNameRule dTCC_UnderlyingAssetNameRule;
	@Inject protected IsAllowableActionForSEC isAllowableActionForSEC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public UnderlyingAssetNameReport evaluate(TransactionReportInstruction input) {
		UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder outputBuilder = doEvaluate(input);
		
		final UnderlyingAssetNameReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(UnderlyingAssetNameReport.class, output);
		}
		
		return output;
	}

	protected abstract UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class DTCC_UnderlyingAssetNameRuleDefault extends DTCC_UnderlyingAssetNameRule {
		@Override
		protected UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder doEvaluate(TransactionReportInstruction input) {
			UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder output = UnderlyingAssetNameReport.builder();
			return assignOutput(output, input);
		}
		
		protected UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder assignOutput(UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForSEC.evaluate(item.get()));
			output = toBuilder(thenArg
				.mapSingleToItem(item -> MapperS.of(dTCC_UnderlyingAssetNameRule.evaluate(item.get()))).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
