package drr.regulation.sec.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 7.0.0-dev.52
 */
@RosettaDataRule("SECTransactionReportDTCC_SEC_VR_Payment1Receiver")
@ImplementedBy(SECTransactionReportDTCC_SEC_VR_Payment1Receiver.Default.class)
public interface SECTransactionReportDTCC_SEC_VR_Payment1Receiver extends Validator<SECTransactionReport> {
	
	String NAME = "SECTransactionReportDTCC_SEC_VR_Payment1Receiver";
	String DEFINITION = "if leg1 -> payerIdentifier exists or (buyerIdentifier is absent and sellerIdentifier is absent) then leg1 -> receiverIdentifier exists and (leg1 -> receiverIdentifier = counterparty1 or leg1 -> receiverIdentifier = counterparty2) else leg1 -> receiverIdentifier is absent";
	
	class Default implements SECTransactionReportDTCC_SEC_VR_Payment1Receiver {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
			ComparisonResult result = executeDataRule(sECTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SECTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "SECTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SECTransactionReport sECTransactionReport) {
			try {
				if (exists(MapperS.of(sECTransactionReport).<CommonLeg>map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).<String>map("getPayerIdentifier", commonLeg -> commonLeg.getPayerIdentifier())).or(notExists(MapperS.of(sECTransactionReport).<String>map("getBuyerIdentifier", _sECTransactionReport -> _sECTransactionReport.getBuyerIdentifier())).and(notExists(MapperS.of(sECTransactionReport).<String>map("getSellerIdentifier", _sECTransactionReport -> _sECTransactionReport.getSellerIdentifier())))).getOrDefault(false)) {
					return exists(MapperS.of(sECTransactionReport).<CommonLeg>map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).<String>map("getReceiverIdentifier", commonLeg -> commonLeg.getReceiverIdentifier())).and(areEqual(MapperS.of(sECTransactionReport).<CommonLeg>map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).<String>map("getReceiverIdentifier", commonLeg -> commonLeg.getReceiverIdentifier()), MapperS.of(sECTransactionReport).<String>map("getCounterparty1", _sECTransactionReport -> _sECTransactionReport.getCounterparty1()), CardinalityOperator.All).or(areEqual(MapperS.of(sECTransactionReport).<CommonLeg>map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).<String>map("getReceiverIdentifier", commonLeg -> commonLeg.getReceiverIdentifier()), MapperS.of(sECTransactionReport).<String>map("getCounterparty2", _sECTransactionReport -> _sECTransactionReport.getCounterparty2()), CardinalityOperator.All)));
				}
				return notExists(MapperS.of(sECTransactionReport).<CommonLeg>map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).<String>map("getReceiverIdentifier", commonLeg -> commonLeg.getReceiverIdentifier()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SECTransactionReportDTCC_SEC_VR_Payment1Receiver {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
			return Collections.emptyList();
		}
	}
}
