package drr.standards.iosco.cde.version1.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.payment.PeriodicPayment;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.base.util.party.functions.CounterpartiesForEvent;
import drr.base.util.party.functions.CounterpartyRoleFromLEI;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.payment.functions.FixedInterestRatePayoutFromPayout;
import drr.regulation.common.trade.payment.functions.FloatingInterestRatePayoutFromPayout;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version1.execution.reports.SettlementCurrencyRule;
import drr.standards.iosco.cde.version1.party.functions.Direction1;
import drr.standards.iosco.cde.version1.party.functions.Direction2;
import drr.standards.iosco.cde.version1.party.reports.Counterparty1Rule;
import drr.standards.iosco.cde.version1.payment.reports.DayCountConventionRule;
import drr.standards.iosco.cde.version1.payment.reports.PaymentFrequencyPeriodMultiplierRule;
import drr.standards.iosco.cde.version1.payment.reports.PaymentFrequencyPeriodRule;
import drr.standards.iosco.cde.version1.price.reports.FixedRateRule;
import drr.standards.iosco.cde.version1.price.reports.SpreadCurrencyRule;
import drr.standards.iosco.cde.version1.price.reports.SpreadValueRule;
import drr.standards.iosco.cde.version1.quantity.functions.NotionalAmountLeg1;
import drr.standards.iosco.cde.version1.quantity.functions.QuantityUnitOfMeasure;
import drr.standards.iosco.cde.version1.quantity.functions.TotalNotionalQuantityLeg1;
import drr.standards.iosco.cde.version1.quantity.reports.NotionalAmountScheduleRule;
import drr.standards.iosco.cde.version1.quantity.reports.NotionalCurrencyLeg1Rule;
import drr.standards.iosco.cde.version1.quantity.reports.NotionalQuantityScheduleRule;
import drr.standards.iso.Direction2Enum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Leg1.Leg1Default.class)
public abstract class Leg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CounterpartiesForEvent counterpartiesForEvent;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected CounterpartyRoleFromLEI counterpartyRoleFromLEI;
	@Inject protected DayCountConventionRule dayCountConventionRule;
	@Inject protected Direction1 direction1;
	@Inject protected Direction2 direction2;
	@Inject protected FixedInterestRatePayoutFromPayout fixedInterestRatePayoutFromPayout;
	@Inject protected FixedRateRule fixedRateRule;
	@Inject protected FloatingInterestRatePayoutFromPayout floatingInterestRatePayoutFromPayout;
	@Inject protected NotionalAmountLeg1 notionalAmountLeg1;
	@Inject protected NotionalAmountScheduleRule notionalAmountScheduleRule;
	@Inject protected NotionalCurrencyLeg1Rule notionalCurrencyLeg1Rule;
	@Inject protected NotionalQuantityScheduleRule notionalQuantityScheduleRule;
	@Inject protected PaymentFrequencyPeriodMultiplierRule paymentFrequencyPeriodMultiplierRule;
	@Inject protected PaymentFrequencyPeriodRule paymentFrequencyPeriodRule;
	@Inject protected PayoutLeg1Rule payoutLeg1Rule;
	@Inject protected PriceFormatFromNotation priceFormatFromNotation;
	@Inject protected QuantityUnitOfMeasure quantityUnitOfMeasure;
	@Inject protected SettlementCurrencyRule settlementCurrencyRule;
	@Inject protected SpreadCurrencyRule spreadCurrencyRule;
	@Inject protected SpreadValueRule spreadValueRule;
	@Inject protected TotalNotionalQuantityLeg1 totalNotionalQuantityLeg1;

	/**
	* @param transaction 
	* @param spreadNotation 
	* @param defaultValue 
	* @return leg 
	*/
	public LegV1 evaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
		LegV1.LegV1Builder legBuilder = doEvaluate(transaction, spreadNotation, defaultValue);
		
		final LegV1 leg;
		if (legBuilder == null) {
			leg = null;
		} else {
			leg = legBuilder.build();
			objectValidator.validate(LegV1.class, leg);
		}
		
		return leg;
	}

	protected abstract LegV1.LegV1Builder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue);

	public static class Leg1Default extends Leg1 {
		@Override
		protected LegV1.LegV1Builder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
			LegV1.LegV1Builder leg = LegV1.builder();
			return assignOutput(leg, transaction, spreadNotation, defaultValue);
		}
		
		protected LegV1.LegV1Builder assignOutput(LegV1.LegV1Builder leg, TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
			leg = toBuilder(MapperS.of(transaction)
				.mapSingleToItem(item -> {
					final BigDecimal bigDecimal0 = paymentFrequencyPeriodMultiplierRule.evaluate(fixedInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(item.get())));
					final BigDecimal bigDecimal1 = paymentFrequencyPeriodMultiplierRule.evaluate(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(item.get())));
					Direction2Enum ifThenElseResult = null;
					if (notExists(MapperS.of(direction1.evaluate(item.get()))).getOrDefault(false)) {
						ifThenElseResult = direction2.evaluate(payoutLeg1Rule.evaluate(item.get()), counterpartyRoleFromLEI.evaluate(counterpartiesForEvent.evaluate(item.get()), counterparty1Rule.evaluate(transaction)));
					}
					return MapperS.of(LegV1.builder()
						.setPeriodicPayment(PeriodicPayment.builder()
							.setFixedRateDayCountConvention(dayCountConventionRule.evaluate(fixedInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(item.get()))))
							.setFloatingRateDayCountConvention(dayCountConventionRule.evaluate(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(item.get()))))
							.setFixedRatePaymentFrequencyPeriod(paymentFrequencyPeriodRule.evaluate(fixedInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(item.get()))))
							.setFloatingRatePaymentFrequencyPeriod(paymentFrequencyPeriodRule.evaluate(floatingInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(item.get()))))
							.setFixedRatePaymentFrequencyPeriodMultiplier((bigDecimal0 == null ? null : bigDecimal0.intValueExact()))
							.setFloatingRatePaymentFrequencyPeriodMultiplier((bigDecimal1 == null ? null : bigDecimal1.intValueExact()))
							.build())
						.setFixedRate(fixedRateRule.evaluate(fixedInterestRatePayoutFromPayout.evaluate(payoutLeg1Rule.evaluate(item.get()))))
						.setNotionalAmount(notionalAmountLeg1.evaluate(transaction, defaultValue))
						.setNotionalCurrency(notionalCurrencyLeg1Rule.evaluate(item.get()))
						.setTotalNotionalQuantity(totalNotionalQuantityLeg1.evaluate(transaction, defaultValue))
						.setNotionalAmountSchedule(new ArrayList(notionalAmountScheduleRule.evaluate(payoutLeg1Rule.evaluate(item.get()))))
						.setNotionalQuantitySchedule(new ArrayList(notionalQuantityScheduleRule.evaluate(payoutLeg1Rule.evaluate(item.get()))))
						.setSettlementCurrency(settlementCurrencyRule.evaluate(payoutLeg1Rule.evaluate(item.get())))
						.setSpread(item
							.mapSingleToItem(_item -> MapperS.of(priceFormatFromNotation.evaluate(spreadValueRule.evaluate(payoutLeg1Rule.evaluate(_item.get())), spreadNotation))).get())
						.setSpreadNotation(spreadNotation)
						.setSpreadCurrency(spreadCurrencyRule.evaluate(payoutLeg1Rule.evaluate(item.get())))
						.setQuantityUnitOfMeasure(quantityUnitOfMeasure.evaluate(payoutLeg1Rule.evaluate(item.get())))
						.setDirection2(ifThenElseResult)
						.build());
				}).get());
			
			return Optional.ofNullable(leg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
