package drr.standards.iosco.cde.version1.quantity.functions;

import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.quantity.functions.GetProductForQuantity;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.trade.functions.PayoutFromProductLeg2;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountLeg2.NotionalAmountLeg2Default.class)
public abstract class NotionalAmountLeg2 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetProductForQuantity getProductForQuantity;
	@Inject protected NotionalAmountFormat notionalAmountFormat;
	@Inject protected PayoutFromProductLeg2 payoutFromProductLeg2;

	/**
	* @param transactionReportInstruction 
	* @param defaultValue 
	* @return notionalAmount 
	*/
	public BigDecimal evaluate(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
		BigDecimal notionalAmount = doEvaluate(transactionReportInstruction, defaultValue);
		
		return notionalAmount;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue);

	protected abstract MapperS<? extends PayoutLegWithAuxiliary> payout(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue);

	public static class NotionalAmountLeg2Default extends NotionalAmountLeg2 {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
			BigDecimal notionalAmount = null;
			return assignOutput(notionalAmount, transactionReportInstruction, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal notionalAmount, TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
			notionalAmount = notionalAmountFormat.evaluate(payout(transactionReportInstruction, defaultValue).get(), defaultValue);
			
			return notionalAmount;
		}
		
		@Override
		protected MapperS<? extends PayoutLegWithAuxiliary> payout(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
			final MapperS<TradableProduct> thenArg = MapperS.of(getProductForQuantity.evaluate(transactionReportInstruction));
			return thenArg
				.mapSingleToItem(item -> MapperS.of(payoutFromProductLeg2.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), MapperS.of(transactionReportInstruction).<ReportableInformation>map("getReportableInformation", transactionReportInstructionBase -> transactionReportInstructionBase.getReportableInformation()).get())));
		}
	}
}
