package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.quantity.functions.GetProductForQuantity;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.trade.functions.PayoutFromProductLeg1;
import drr.standards.iosco.cde.version1.quantity.functions.CurrencyFromNotional;
import drr.standards.iosco.cde.version1.quantity.functions.NotionalFromLeg;
import javax.inject.Inject;


@ImplementedBy(NotionalCurrencyLeg1Rule.NotionalCurrencyLeg1RuleDefault.class)
public abstract class NotionalCurrencyLeg1Rule implements ReportFunction<TransactionReportInstructionBase, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CurrencyFromNotional currencyFromNotional;
	@Inject protected GetProductForQuantity getProductForQuantity;
	@Inject protected NotionalFromLeg notionalFromLeg;
	@Inject protected PayoutFromProductLeg1 payoutFromProductLeg1;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransactionReportInstructionBase input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase input);

	public static class NotionalCurrencyLeg1RuleDefault extends NotionalCurrencyLeg1Rule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstructionBase input) {
			output = MapperS.of(input)
				.mapSingleToItem(reportableEvent -> {
					final MapperS<TradableProduct> thenArg = MapperS.of(getProductForQuantity.evaluate(input));
					return MapperS.of(currencyFromNotional.evaluate(notionalFromLeg.evaluate(thenArg
						.mapSingleToItem(item -> MapperS.of(payoutFromProductLeg1.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstructionBase -> transactionReportInstructionBase.getReportableInformation()).get()))).get())));
				}).get();
			
			return output;
		}
	}
}
