package drr.standards.iosco.cde.version2.collateral.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import javax.inject.Inject;


@ImplementedBy(CurrencyOfExcessCollateralPostedRule.CurrencyOfExcessCollateralPostedRuleDefault.class)
public abstract class CurrencyOfExcessCollateralPostedRule implements ReportFunction<CollateralReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version1.collateral.reports.CurrencyOfExcessCollateralPostedRule currencyOfExcessCollateralPostedRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(CollateralReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(CollateralReportInstruction input);

	public static class CurrencyOfExcessCollateralPostedRuleDefault extends CurrencyOfExcessCollateralPostedRule {
		@Override
		protected String doEvaluate(CollateralReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, CollateralReportInstruction input) {
			output = currencyOfExcessCollateralPostedRule.evaluate(input);
			
			return output;
		}
	}
}
