package drr.standards.iosco.cde.version2.quantity.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.trade.TransactionReportInstructionBase;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(ExtractPutAmount.ExtractPutAmountDefault.class)
public abstract class ExtractPutAmount implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version1.quantity.functions.ExtractPutAmount extractPutAmount;

	/**
	* @param transactionReportInstruction 
	* @param defaultValue 
	* @return putAmount 
	*/
	public BigDecimal evaluate(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
		BigDecimal putAmount = doEvaluate(transactionReportInstruction, defaultValue);
		
		return putAmount;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue);

	public static class ExtractPutAmountDefault extends ExtractPutAmount {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
			BigDecimal putAmount = null;
			return assignOutput(putAmount, transactionReportInstruction, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal putAmount, TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
			putAmount = extractPutAmount.evaluate(transactionReportInstruction, defaultValue);
			
			return putAmount;
		}
	}
}
