package drr.standards.iosco.cde.version3.quantity.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.trade.TransactionReportInstructionBase;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(ExtractCallAmount.ExtractCallAmountDefault.class)
public abstract class ExtractCallAmount implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version2.quantity.functions.ExtractCallAmount extractCallAmount;

	/**
	* @param transactionReportInstruction 
	* @param defaultValue 
	* @return callAmount 
	*/
	public BigDecimal evaluate(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
		BigDecimal callAmount = doEvaluate(transactionReportInstruction, defaultValue);
		
		return callAmount;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue);

	public static class ExtractCallAmountDefault extends ExtractCallAmount {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
			BigDecimal callAmount = null;
			return assignOutput(callAmount, transactionReportInstruction, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal callAmount, TransactionReportInstructionBase transactionReportInstruction, BigDecimal defaultValue) {
			callAmount = extractCallAmount.evaluate(transactionReportInstruction, defaultValue);
			
			return callAmount;
		}
	}
}
