package drr.standards.iosco.cde.version3.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version3.CriticalDataElement;
import drr.standards.iosco.cde.version3.basket.reports.BasketConstituentsRule;
import drr.standards.iosco.cde.version3.basket.reports.CustomBasketCodeRule;
import drr.standards.iosco.cde.version3.collateral.reports.CollateralPortfolioIndicatorRule;
import drr.standards.iosco.cde.version3.datetime.reports.EarlyTerminationDateRule;
import drr.standards.iosco.cde.version3.datetime.reports.EffectiveDateRule;
import drr.standards.iosco.cde.version3.datetime.reports.EventTimestampRule;
import drr.standards.iosco.cde.version3.datetime.reports.ExecutionTimestampRule;
import drr.standards.iosco.cde.version3.datetime.reports.ReportingTimestampRule;
import drr.standards.iosco.cde.version3.datetime.reports.ValuationTimestampRule;
import drr.standards.iosco.cde.version3.event.reports.ActionTypeRule;
import drr.standards.iosco.cde.version3.event.reports.EventIdentifierRule;
import drr.standards.iosco.cde.version3.event.reports.EventTypeRule;
import drr.standards.iosco.cde.version3.event.reports.LevelRule;
import drr.standards.iosco.cde.version3.execution.reports.CentralCounterpartyRule;
import drr.standards.iosco.cde.version3.execution.reports.ClearedRule;
import drr.standards.iosco.cde.version3.execution.reports.ClearingMemberRule;
import drr.standards.iosco.cde.version3.execution.reports.ConfirmedRule;
import drr.standards.iosco.cde.version3.execution.reports.FinalContractualSettlementDateRule;
import drr.standards.iosco.cde.version3.index.reports.CDSIndexAttachmentPointRule;
import drr.standards.iosco.cde.version3.index.reports.CDSIndexDetachmentPointRule;
import drr.standards.iosco.cde.version3.labels.CPMI_IOSCOCDELabelProvider;
import drr.standards.iosco.cde.version3.link.reports.PackageIdentifierRule;
import drr.standards.iosco.cde.version3.link.reports.PriorUTIRule;
import drr.standards.iosco.cde.version3.party.reports.Beneficiary1IdentifierTypeIndicatorRule;
import drr.standards.iosco.cde.version3.party.reports.Beneficiary1Rule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty1Rule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty2IdentifierTypeIndicatorRule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty2Rule;
import drr.standards.iosco.cde.version3.party.reports.Direction1BuyerIdentifierRule;
import drr.standards.iosco.cde.version3.party.reports.Direction1Rule;
import drr.standards.iosco.cde.version3.party.reports.Direction1SellerIdentifierRule;
import drr.standards.iosco.cde.version3.payment.reports.OtherPaymentRule;
import drr.standards.iosco.cde.version3.price.reports.ExchangeRateBasisRule;
import drr.standards.iosco.cde.version3.price.reports.ExchangeRateRule;
import drr.standards.iosco.cde.version3.price.reports.FirstExerciseDateRule;
import drr.standards.iosco.cde.version3.price.reports.OptionPremiumAmountRule;
import drr.standards.iosco.cde.version3.price.reports.OptionPremiumCurrencyRule;
import drr.standards.iosco.cde.version3.price.reports.OptionPremiumPaymentDateRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionPriceCurrencyRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionPriceFormatRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionPriceNotationEnumRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionSpreadCurrencyRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionSpreadFormatRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionSpreadNotationEnumRule;
import drr.standards.iosco.cde.version3.price.reports.PriceCurrencyRule;
import drr.standards.iosco.cde.version3.price.reports.PriceFormatRule;
import drr.standards.iosco.cde.version3.price.reports.PriceNotationRule;
import drr.standards.iosco.cde.version3.price.reports.PriceScheduleRule;
import drr.standards.iosco.cde.version3.price.reports.PriceUnitOfMeasureRule;
import drr.standards.iosco.cde.version3.price.reports.StrikePriceCurrencyRule;
import drr.standards.iosco.cde.version3.price.reports.StrikePriceFormatRule;
import drr.standards.iosco.cde.version3.price.reports.StrikePriceNotationEnumRule;
import drr.standards.iosco.cde.version3.price.reports.StrikePriceScheduleRule;
import drr.standards.iosco.cde.version3.quantity.reports.CallAmountRule;
import drr.standards.iosco.cde.version3.quantity.reports.CallCurrencyRule;
import drr.standards.iosco.cde.version3.quantity.reports.DeltaRule;
import drr.standards.iosco.cde.version3.quantity.reports.PutAmountRule;
import drr.standards.iosco.cde.version3.quantity.reports.PutCurrencyRule;
import drr.standards.iosco.cde.version3.underlier.reports.CryptoAssetUnderlyingIndicatorRule;
import drr.standards.iosco.cde.version3.underlier.reports.UnderlierIDOtherRule;
import drr.standards.iosco.cde.version3.underlier.reports.UnderlierIDOtherSourceRule;
import drr.standards.iosco.cde.version3.valuation.reports.ValuationAmountRule;
import drr.standards.iosco.cde.version3.valuation.reports.ValuationCurrencyRule;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.standards.iosco.cde.version3", body="CPMI_IOSCO", corpusList={"CDE"})
@RuneLabelProvider(labelProvider=CPMI_IOSCOCDELabelProvider.class)
@ImplementedBy(CPMI_IOSCOCDEReportFunction.CPMI_IOSCOCDEReportFunctionDefault.class)
public abstract class CPMI_IOSCOCDEReportFunction implements ReportFunction<TransactionReportInstruction, CriticalDataElement> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected BasketConstituentsRule basketConstituentsRule;
	@Inject protected Beneficiary1IdentifierTypeIndicatorRule beneficiary1IdentifierTypeIndicatorRule;
	@Inject protected Beneficiary1Rule beneficiary1Rule;
	@Inject protected CDSIndexAttachmentPointRule cDSIndexAttachmentPointRule;
	@Inject protected CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected CentralCounterpartyRule centralCounterpartyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingMemberRule clearingMemberRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected ConfirmedRule confirmedRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CryptoAssetUnderlyingIndicatorRule cryptoAssetUnderlyingIndicatorRule;
	@Inject protected CustomBasketCodeRule customBasketCodeRule;
	@Inject protected DeltaRule deltaRule;
	@Inject protected Direction1BuyerIdentifierRule direction1BuyerIdentifierRule;
	@Inject protected Direction1Rule direction1Rule;
	@Inject protected Direction1SellerIdentifierRule direction1SellerIdentifierRule;
	@Inject protected EarlyTerminationDateRule earlyTerminationDateRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EventIdentifierRule eventIdentifierRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
	@Inject protected FirstExerciseDateRule firstExerciseDateRule;
	@Inject protected LevelRule levelRule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceFormatRule packageTransactionPriceFormatRule;
	@Inject protected PackageTransactionPriceNotationEnumRule packageTransactionPriceNotationEnumRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadFormatRule packageTransactionSpreadFormatRule;
	@Inject protected PackageTransactionSpreadNotationEnumRule packageTransactionSpreadNotationEnumRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceFormatRule priceFormatRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceScheduleRule priceScheduleRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PriorUTIRule priorUTIRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected StrikePriceCurrencyRule strikePriceCurrencyRule;
	@Inject protected StrikePriceFormatRule strikePriceFormatRule;
	@Inject protected StrikePriceNotationEnumRule strikePriceNotationEnumRule;
	@Inject protected StrikePriceScheduleRule strikePriceScheduleRule;
	@Inject protected UnderlierIDOtherRule underlierIDOtherRule;
	@Inject protected UnderlierIDOtherSourceRule underlierIDOtherSourceRule;
	@Inject protected ValuationAmountRule valuationAmountRule;
	@Inject protected ValuationCurrencyRule valuationCurrencyRule;
	@Inject protected ValuationTimestampRule valuationTimestampRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CriticalDataElement evaluate(TransactionReportInstruction input) {
		CriticalDataElement.CriticalDataElementBuilder outputBuilder = doEvaluate(input);
		
		final CriticalDataElement output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CriticalDataElement.class, output);
		}
		
		return output;
	}

	protected abstract CriticalDataElement.CriticalDataElementBuilder doEvaluate(TransactionReportInstruction input);

	public static class CPMI_IOSCOCDEReportFunctionDefault extends CPMI_IOSCOCDEReportFunction {
		@Override
		protected CriticalDataElement.CriticalDataElementBuilder doEvaluate(TransactionReportInstruction input) {
			CriticalDataElement.CriticalDataElementBuilder output = CriticalDataElement.builder();
			return assignOutput(output, input);
		}
		
		protected CriticalDataElement.CriticalDataElementBuilder assignOutput(CriticalDataElement.CriticalDataElementBuilder output, TransactionReportInstruction input) {
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setEarlyTerminationDate(earlyTerminationDateRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setBeneficiary1(beneficiary1Rule.evaluate(input));
			
			output
				.setBeneficiary1IdentifierTypeIndicator(beneficiary1IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setBuyerIdentifier(direction1BuyerIdentifierRule.evaluate(input));
			
			output
				.setSellerIdentifier(direction1SellerIdentifierRule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCentralCounterparty(centralCounterpartyRule.evaluate(input));
			
			output
				.setClearingMember(clearingMemberRule.evaluate(input));
			
			output
				.setConfirmed(confirmedRule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setDelta(deltaRule.evaluate(input));
			
			output
				.setPriceSchedule(priceScheduleRule.evaluate(input));
			
			output
				.setStrikePriceSchedule(strikePriceScheduleRule.evaluate(input));
			
			output
				.setPrice(priceFormatRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionPrice(packageTransactionPriceFormatRule.evaluate(input));
			
			output
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationEnumRule.evaluate(input));
			
			output
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionSpread(packageTransactionSpreadFormatRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationEnumRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.setStrikePrice(strikePriceFormatRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationEnumRule.evaluate(input));
			
			output
				.setStrikePriceCurrency(strikePriceCurrencyRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setOptionPremiumPaymentDate(optionPremiumPaymentDateRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setCdSIndexAttachmentPoint(cDSIndexAttachmentPointRule.evaluate(input));
			
			output
				.setCdSIndexDetachmentPoint(cDSIndexDetachmentPointRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setFirstExerciseDate(firstExerciseDateRule.evaluate(input));
			
			output
				.setFinalContractualSettlementDate(finalContractualSettlementDateRule.evaluate(input));
			
			output
				.setPriorUTI(priorUTIRule.evaluate(input));
			
			output
				.setDirection1(direction1Rule.evaluate(input));
			
			output
				.setValuationAmount(valuationAmountRule.evaluate(input));
			
			output
				.setValuationCurrency(valuationCurrencyRule.evaluate(input));
			
			output
				.setValuationTimestamp(valuationTimestampRule.evaluate(input));
			
			output
				.setCustomBasketCode(customBasketCodeRule.evaluate(input));
			
			output
				.setBasketConstituents(basketConstituentsRule.evaluate(input));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.setUnderlyingIdOther(underlierIDOtherRule.evaluate(input));
			
			output
				.setUnderlyingIdOtherSource(underlierIDOtherSourceRule.evaluate(input));
			
			output
				.setCryptoAssetUnderlyingIndicator(cryptoAssetUnderlyingIndicatorRule.evaluate(input));
			
			output
				.setLevel(levelRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEventIdentifier(eventIdentifierRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
