/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.IndexObservation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class FxIndexObservation
implements IndexObservation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FxIndex index;
    @PropertyDefinition(validate="notNull")
    private final LocalDate fixingDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate maturityDate;
    private static final long serialVersionUID = 1L;

    public static FxIndexObservation of(FxIndex index, LocalDate fixingDate, ReferenceData refData) {
        LocalDate maturityDate = index.calculateMaturityFromFixing(fixingDate, refData);
        return new FxIndexObservation(index, fixingDate, maturityDate);
    }

    public CurrencyPair getCurrencyPair() {
        return this.index.getCurrencyPair();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxIndexObservation other = (FxIndexObservation)obj;
            return this.index.equals(other.index) && this.fixingDate.equals(other.fixingDate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + this.index.hashCode();
        return hash * 31 + this.fixingDate.hashCode();
    }

    public String toString() {
        return new StringBuilder(64).append("FxIndexObservation[").append(this.index).append(" on ").append(this.fixingDate).append(']').toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    FxIndexObservation(FxIndex index, LocalDate fixingDate, LocalDate maturityDate) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)fixingDate, (String)"fixingDate");
        JodaBeanUtils.notNull((Object)maturityDate, (String)"maturityDate");
        this.index = index;
        this.fixingDate = fixingDate;
        this.maturityDate = maturityDate;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public FxIndex getIndex() {
        return this.index;
    }

    public LocalDate getFixingDate() {
        return this.fixingDate;
    }

    public LocalDate getMaturityDate() {
        return this.maturityDate;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxIndexObservation> {
        private FxIndex index;
        private LocalDate fixingDate;
        private LocalDate maturityDate;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case -414641441: {
                    return this.maturityDate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (FxIndex)newValue;
                    break;
                }
                case 1255202043: {
                    this.fixingDate = (LocalDate)newValue;
                    break;
                }
                case -414641441: {
                    this.maturityDate = (LocalDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxIndexObservation build() {
            return new FxIndexObservation(this.index, this.fixingDate, this.maturityDate);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("FxIndexObservation.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("fixingDate").append('=').append(JodaBeanUtils.toString((Object)this.fixingDate)).append(',').append(' ');
            buf.append("maturityDate").append('=').append(JodaBeanUtils.toString((Object)this.maturityDate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", FxIndexObservation.class, FxIndex.class);
        private final MetaProperty<LocalDate> fixingDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDate", FxIndexObservation.class, LocalDate.class);
        private final MetaProperty<LocalDate> maturityDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"maturityDate", FxIndexObservation.class, LocalDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "fixingDate", "maturityDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case -414641441: {
                    return this.maturityDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxIndexObservation> builder() {
            return new Builder();
        }

        public Class<? extends FxIndexObservation> beanType() {
            return FxIndexObservation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxIndex> index() {
            return this.index;
        }

        public MetaProperty<LocalDate> fixingDate() {
            return this.fixingDate;
        }

        public MetaProperty<LocalDate> maturityDate() {
            return this.maturityDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((FxIndexObservation)bean).getIndex();
                }
                case 1255202043: {
                    return ((FxIndexObservation)bean).getFixingDate();
                }
                case -414641441: {
                    return ((FxIndexObservation)bean).getMaturityDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

