/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.ImmutablePriceIndex;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.location.Country;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.collect.io.CsvFile;
import com.opengamma.strata.collect.io.CsvRow;
import com.opengamma.strata.collect.io.ResourceConfig;
import com.opengamma.strata.collect.io.ResourceLocator;
import com.opengamma.strata.collect.named.NamedLookup;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class PriceIndexCsvLookup
implements NamedLookup<PriceIndex> {
    private static final Logger log = Logger.getLogger(PriceIndexCsvLookup.class.getName());
    public static final PriceIndexCsvLookup INSTANCE = new PriceIndexCsvLookup();
    private static final String NAME_FIELD = "Name";
    private static final String CURRENCY_FIELD = "Currency";
    private static final String COUNTRY_FIELD = "Country";
    private static final String ACTIVE_FIELD = "Active";
    private static final String PUBLICATION_FREQUENCY_FIELD = "Publication Frequency";
    private static final ImmutableMap<String, PriceIndex> BY_NAME = PriceIndexCsvLookup.loadFromCsv();

    private PriceIndexCsvLookup() {
    }

    public Map<String, PriceIndex> lookupAll() {
        return BY_NAME;
    }

    private static ImmutableMap<String, PriceIndex> loadFromCsv() {
        List resources = ResourceConfig.orderedResources((String)"PriceIndexData.csv");
        HashMap<String, PriceIndex> map = new HashMap<String, PriceIndex>();
        for (ResourceLocator resource : resources) {
            try {
                CsvFile csv = CsvFile.of((CharSource)resource.getCharSource(), (boolean)true);
                for (CsvRow row : csv.rows()) {
                    PriceIndex parsed = PriceIndexCsvLookup.parsePriceIndex(row);
                    map.put(parsed.getName(), parsed);
                    map.putIfAbsent(parsed.getName().toUpperCase(Locale.ENGLISH), parsed);
                }
            }
            catch (RuntimeException ex) {
                log.log(Level.SEVERE, "Error processing resource as Price Index CSV file: " + resource, ex);
                return ImmutableMap.of();
            }
        }
        return ImmutableMap.copyOf(map);
    }

    private static PriceIndex parsePriceIndex(CsvRow row) {
        String name = row.getField(NAME_FIELD);
        Currency currency = Currency.parse(row.getField(CURRENCY_FIELD));
        Country region = Country.of(row.getField(COUNTRY_FIELD));
        boolean active = Boolean.parseBoolean(row.getField(ACTIVE_FIELD));
        Frequency frequency = Frequency.parse(row.getField(PUBLICATION_FREQUENCY_FIELD));
        return ImmutablePriceIndex.builder().name(name).currency(currency).region(region).active(active).publicationFrequency(frequency).build();
    }
}

