/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Optional;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.function.CheckedSupplier;
import com.opengamma.strata.collect.io.UnicodeBom;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class ArrayByteSource
extends ByteSource {
    public static final ArrayByteSource EMPTY = new ArrayByteSource(new byte[0]);
    private final byte[] array;

    public static ArrayByteSource copyOf(byte[] array) {
        return new ArrayByteSource((byte[])array.clone());
    }

    public static ArrayByteSource copyOf(byte[] array, int fromIndex) {
        return ArrayByteSource.copyOf(array, fromIndex, array.length);
    }

    public static ArrayByteSource copyOf(byte[] array, int fromIndexInclusive, int toIndexExclusive) {
        if (fromIndexInclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + fromIndexInclusive + " > " + array.length);
        }
        if (toIndexExclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + toIndexExclusive + " > " + array.length);
        }
        if (toIndexExclusive - fromIndexInclusive == 0) {
            return EMPTY;
        }
        return new ArrayByteSource(Arrays.copyOfRange(array, fromIndexInclusive, toIndexExclusive));
    }

    public static ArrayByteSource ofUnsafe(byte[] array) {
        return new ArrayByteSource(array);
    }

    public static ArrayByteSource from(ByteSource other) {
        if (other instanceof ArrayByteSource) {
            return (ArrayByteSource)other;
        }
        return new ArrayByteSource(Unchecked.wrap(() -> other.read()));
    }

    public static ArrayByteSource from(CheckedSupplier<InputStream> inputStreamSupplier) {
        return Unchecked.wrap(() -> {
            try (InputStream in = (InputStream)inputStreamSupplier.get();){
                byte[] bytes = Unchecked.wrap(() -> ByteStreams.toByteArray((InputStream)in));
                ArrayByteSource arrayByteSource = new ArrayByteSource(bytes);
                return arrayByteSource;
            }
        });
    }

    private ArrayByteSource(byte[] array) {
        this.array = array;
    }

    public byte[] readUnsafe() {
        return this.array;
    }

    public String readUtf8() {
        return new String(this.array, StandardCharsets.UTF_8);
    }

    public String readUtf8UsingBom() {
        return UnicodeBom.toString(this.array);
    }

    public CharSource asCharSourceUtf8UsingBom() {
        return CharSource.wrap((CharSequence)this.readUtf8UsingBom());
    }

    public ByteArrayInputStream openStream() {
        return new ByteArrayInputStream(this.array);
    }

    public ByteArrayInputStream openBufferedStream() {
        return this.openStream();
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public Optional<Long> sizeIfKnown() {
        return Optional.of((Object)this.size());
    }

    public long size() {
        return this.array.length;
    }

    public long copyTo(OutputStream output) throws IOException {
        output.write(this.array);
        return this.array.length;
    }

    public byte[] read() {
        return (byte[])this.array.clone();
    }

    public <T> T read(ByteProcessor<T> processor) throws IOException {
        processor.processBytes(this.array, 0, this.array.length);
        return (T)processor.getResult();
    }

    public HashCode hash(HashFunction hashFunction) {
        return hashFunction.hashBytes(this.array);
    }

    public String toString() {
        return "ArrayByteSource[" + this.size() + " bytes]";
    }
}

