/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SecurityBondEconomicTerms")
@ImplementedBy(value=Default.class)
public interface SecurityBondEconomicTerms
extends Validator<Security> {
    public static final String NAME = "SecurityBondEconomicTerms";
    public static final String DEFINITION = "if economicTerms exists then securityType = SecurityTypeEnum -> Debt";

    public static class NoOp
    implements SecurityBondEconomicTerms {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Security security) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SecurityBondEconomicTerms {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Security security) {
            ComparisonResult result = this.executeDataRule(security);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SecurityBondEconomicTerms.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Security", (RosettaPath)path, (String)SecurityBondEconomicTerms.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SecurityBondEconomicTerms.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Security", (RosettaPath)path, (String)SecurityBondEconomicTerms.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Security security) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)security).map("getEconomicTerms", _security -> _security.getEconomicTerms())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)security).map("getSecurityType", _security -> _security.getSecurityType()), (Mapper)MapperS.of((Object)((Object)SecurityTypeEnum.DEBT)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

