/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.qualification.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.functions.FilterQuantityByCurrencyExists;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.BusinessEvent;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=Qualify_StockSplitDefault.class)
public abstract class Qualify_StockSplit
implements RosettaFunction,
IQualifyFunctionExtension<BusinessEvent> {
    @Inject
    protected FilterQuantityByCurrencyExists filterQuantityByCurrencyExists;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

    public Boolean evaluate(BusinessEvent businessEvent) {
        Boolean is_event = this.doEvaluate(businessEvent);
        return is_event;
    }

    protected abstract Boolean doEvaluate(BusinessEvent var1);

    protected abstract MapperS<? extends ReferenceWithMetaTradeState> beforeTradeState(BusinessEvent var1);

    protected abstract MapperS<? extends TradeState> afterTradeState(BusinessEvent var1);

    protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> beforeQuantities(BusinessEvent var1);

    protected abstract MapperS<BigDecimal> beforeNoOfUnits(BusinessEvent var1);

    protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> afterQuantities(BusinessEvent var1);

    protected abstract MapperS<BigDecimal> afterNoOfUnits(BusinessEvent var1);

    protected abstract MapperS<BigDecimal> beforeCurrencyAmount(BusinessEvent var1);

    protected abstract MapperS<BigDecimal> afterCurrencyAmount(BusinessEvent var1);

    protected abstract MapperS<BigDecimal> beforePrice(BusinessEvent var1);

    protected abstract MapperS<BigDecimal> afterPrice(BusinessEvent var1);

    protected abstract MapperS<Boolean> currencyAmountUnchanged(BusinessEvent var1);

    protected abstract MapperS<Boolean> noOfUnitsChanged(BusinessEvent var1);

    protected abstract MapperS<Boolean> cashPriceChanged(BusinessEvent var1);

    protected abstract MapperS<Boolean> adjustmentRatioMatches(BusinessEvent var1);

    public String getNamePrefix() {
        return "Qualify";
    }

    public static class Qualify_StockSplitDefault
    extends Qualify_StockSplit {
        @Override
        protected Boolean doEvaluate(BusinessEvent businessEvent) {
            Boolean is_event = null;
            return this.assignOutput(is_event, businessEvent);
        }

        protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
            is_event = ExpressionOperators.areEqual(this.currencyAmountUnchanged(businessEvent), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual(this.noOfUnitsChanged(businessEvent), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual(this.cashPriceChanged(businessEvent), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual(this.adjustmentRatioMatches(businessEvent), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).get();
            return is_event;
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaTradeState> beforeTradeState(BusinessEvent businessEvent) {
            return MapperS.of((Object)((ReferenceWithMetaTradeState)MapperS.of((Object)businessEvent).mapC("getInstruction", _businessEvent -> _businessEvent.getInstruction()).map("getBefore", instruction -> instruction.getBefore()).get()));
        }

        @Override
        protected MapperS<? extends TradeState> afterTradeState(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeState)MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).get()));
        }

        @Override
        protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> beforeQuantities(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeLot)this.beforeTradeState(businessEvent).map("Type coercion", referenceWithMetaTradeState -> referenceWithMetaTradeState == null ? null : referenceWithMetaTradeState.getValue()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity());
        }

        @Override
        protected MapperS<BigDecimal> beforeNoOfUnits(BusinessEvent businessEvent) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(this.beforeQuantities(businessEvent).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti(), FinancialUnitEnum.SHARE)).get())).map("getValue", quantitySchedule -> quantitySchedule.getValue());
        }

        @Override
        protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> afterQuantities(BusinessEvent businessEvent) {
            return this.afterTradeState(businessEvent).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity());
        }

        @Override
        protected MapperS<BigDecimal> afterNoOfUnits(BusinessEvent businessEvent) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(this.afterQuantities(businessEvent).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti(), FinancialUnitEnum.SHARE)).get())).map("getValue", quantitySchedule -> quantitySchedule.getValue());
        }

        @Override
        protected MapperS<BigDecimal> beforeCurrencyAmount(BusinessEvent businessEvent) {
            return MapperS.of((Object)((BigDecimal)ExpressionOperators.distinct((Mapper)MapperC.of(this.filterQuantityByCurrencyExists.evaluate(this.beforeQuantities(businessEvent).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti())).map("getValue", quantitySchedule -> quantitySchedule.getValue())).get()));
        }

        @Override
        protected MapperS<BigDecimal> afterCurrencyAmount(BusinessEvent businessEvent) {
            return MapperS.of((Object)((BigDecimal)ExpressionOperators.distinct((Mapper)MapperC.of(this.filterQuantityByCurrencyExists.evaluate(this.afterQuantities(businessEvent).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti())).map("getValue", quantitySchedule -> quantitySchedule.getValue())).get()));
        }

        @Override
        protected MapperS<BigDecimal> beforePrice(BusinessEvent businessEvent) {
            MapperC thenArg0 = MapperS.of((Object)((TradeLot)this.beforeTradeState(businessEvent).map("Type coercion", referenceWithMetaTradeState -> referenceWithMetaTradeState == null ? null : referenceWithMetaTradeState.getValue()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()));
            return MapperS.of((Object)((BigDecimal)thenArg1.get()));
        }

        @Override
        protected MapperS<BigDecimal> afterPrice(BusinessEvent businessEvent) {
            MapperC thenArg0 = MapperS.of((Object)((TradeLot)this.afterTradeState(businessEvent).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()));
            return MapperS.of((Object)((BigDecimal)thenArg1.get()));
        }

        @Override
        protected MapperS<Boolean> currencyAmountUnchanged(BusinessEvent businessEvent) {
            if (ExpressionOperators.exists(this.beforeCurrencyAmount(businessEvent)).and(ExpressionOperators.exists(this.afterCurrencyAmount(businessEvent))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual(this.beforeCurrencyAmount(businessEvent), this.afterCurrencyAmount(businessEvent), (CardinalityOperator)CardinalityOperator.All).asMapper();
            }
            return MapperS.of((Object)false);
        }

        @Override
        protected MapperS<Boolean> noOfUnitsChanged(BusinessEvent businessEvent) {
            if (ExpressionOperators.exists(this.beforeNoOfUnits(businessEvent)).and(ExpressionOperators.exists(this.afterNoOfUnits(businessEvent))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.notEqual(this.afterNoOfUnits(businessEvent), this.beforeNoOfUnits(businessEvent), (CardinalityOperator)CardinalityOperator.Any).asMapper();
            }
            return MapperS.of((Object)false);
        }

        @Override
        protected MapperS<Boolean> cashPriceChanged(BusinessEvent businessEvent) {
            if (ExpressionOperators.exists(this.beforePrice(businessEvent)).and(ExpressionOperators.exists(this.afterPrice(businessEvent))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.notEqual(this.beforePrice(businessEvent), this.afterPrice(businessEvent), (CardinalityOperator)CardinalityOperator.Any).asMapper();
            }
            return MapperS.of((Object)false);
        }

        @Override
        protected MapperS<Boolean> adjustmentRatioMatches(BusinessEvent businessEvent) {
            if (ExpressionOperators.exists(this.beforeNoOfUnits(businessEvent)).and(ExpressionOperators.greaterThan(this.beforeNoOfUnits(businessEvent), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.exists(this.afterNoOfUnits(businessEvent))).and(ExpressionOperators.exists(this.beforePrice(businessEvent))).and(ExpressionOperators.exists(this.afterPrice(businessEvent))).and(ExpressionOperators.greaterThan(this.afterPrice(businessEvent), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperMaths.divide(this.afterNoOfUnits(businessEvent), this.beforeNoOfUnits(businessEvent)), (Mapper)MapperMaths.divide(this.beforePrice(businessEvent), this.afterPrice(businessEvent)), (CardinalityOperator)CardinalityOperator.All).asMapper();
            }
            return MapperS.of((Object)false);
        }
    }
}

