/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event.functions;

import cdm.base.math.AveragingCalculationMethodEnum;
import cdm.event.common.Reset;
import cdm.observable.event.Observation;
import cdm.observable.event.functions.ResolveObservationAverage;
import cdm.observable.event.metafields.ReferenceWithMetaObservation;
import cdm.product.template.AssetPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=Create_AssetResetDefault.class)
public abstract class Create_AssetReset
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ResolveObservationAverage resolveObservationAverage;

    public Reset evaluate(AssetPayout assetPayout, List<? extends Observation> observation, Date resetDate) {
        Reset reset;
        Reset.ResetBuilder resetBuilder = this.doEvaluate(assetPayout, observation, resetDate);
        if (resetBuilder == null) {
            reset = null;
        } else {
            reset = resetBuilder.build();
            this.objectValidator.validate(Reset.class, (RosettaModelObject)reset);
        }
        return reset;
    }

    protected abstract Reset.ResetBuilder doEvaluate(AssetPayout var1, List<? extends Observation> var2, Date var3);

    public static class Create_AssetResetDefault
    extends Create_AssetReset {
        @Override
        protected Reset.ResetBuilder doEvaluate(AssetPayout assetPayout, List<? extends Observation> observation, Date resetDate) {
            if (observation == null) {
                observation = Collections.emptyList();
            }
            Reset.ResetBuilder reset = Reset.builder();
            return this.assignOutput(reset, assetPayout, observation, resetDate);
        }

        protected Reset.ResetBuilder assignOutput(Reset.ResetBuilder reset, AssetPayout assetPayout, List<? extends Observation> observation, Date resetDate) {
            reset.setResetValue(this.resolveObservationAverage.evaluate(observation));
            reset.setResetDate(resetDate);
            reset.addObservations(observation.stream().map(_observation -> ReferenceWithMetaObservation.builder().setValue((Observation)_observation).build()).collect(Collectors.toList()));
            reset.getOrCreateAveragingMethodology().getOrCreateAveragingMethod().setCalculationMethod(AveragingCalculationMethodEnum.ARITHMETIC);
            return Optional.ofNullable(reset).map(o -> o.prune()).orElse(null);
        }
    }
}

