/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.party.LegalEntity;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaLegalEntity;
import cdm.product.asset.meta.ReferenceObligationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ReferenceObligation", builder=ReferenceObligationBuilderImpl.class, version="5.29.0")
@RuneDataType(value="ReferenceObligation", model="cdm", builder=ReferenceObligationBuilderImpl.class, version="5.29.0")
public interface ReferenceObligation
extends RosettaModelObject {
    public static final ReferenceObligationMeta metaData = new ReferenceObligationMeta();

    public Security getSecurity();

    public Loan getLoan();

    public LegalEntity getPrimaryObligor();

    public ReferenceWithMetaLegalEntity getPrimaryObligorReference();

    public LegalEntity getGuarantor();

    public String getGuarantorReference();

    public Boolean getStandardReferenceObligation();

    public ReferenceObligation build();

    public ReferenceObligationBuilder toBuilder();

    public static ReferenceObligationBuilder builder() {
        return new ReferenceObligationBuilderImpl();
    }

    default public RosettaMetaData<? extends ReferenceObligation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReferenceObligation> getType() {
        return ReferenceObligation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("security"), processor, Security.class, this.getSecurity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loan"), processor, Loan.class, this.getLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("primaryObligor"), processor, LegalEntity.class, this.getPrimaryObligor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("primaryObligorReference"), processor, ReferenceWithMetaLegalEntity.class, this.getPrimaryObligorReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("guarantor"), processor, LegalEntity.class, this.getGuarantor(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("guarantorReference"), String.class, (Object)this.getGuarantorReference(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("standardReferenceObligation"), Boolean.class, (Object)this.getStandardReferenceObligation(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ReferenceObligationBuilderImpl
    implements ReferenceObligationBuilder {
        protected Security.SecurityBuilder security;
        protected Loan.LoanBuilder loan;
        protected LegalEntity.LegalEntityBuilder primaryObligor;
        protected ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder primaryObligorReference;
        protected LegalEntity.LegalEntityBuilder guarantor;
        protected String guarantorReference;
        protected Boolean standardReferenceObligation;

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public Security.SecurityBuilder getSecurity() {
            return this.security;
        }

        @Override
        public Security.SecurityBuilder getOrCreateSecurity() {
            Security.SecurityBuilder result = this.security != null ? this.security : (this.security = Security.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public Loan.LoanBuilder getLoan() {
            return this.loan;
        }

        @Override
        public Loan.LoanBuilder getOrCreateLoan() {
            Loan.LoanBuilder result = this.loan != null ? this.loan : (this.loan = Loan.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="primaryObligor")
        @RuneAttribute(value="primaryObligor")
        public LegalEntity.LegalEntityBuilder getPrimaryObligor() {
            return this.primaryObligor;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreatePrimaryObligor() {
            LegalEntity.LegalEntityBuilder result = this.primaryObligor != null ? this.primaryObligor : (this.primaryObligor = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="primaryObligorReference")
        @RuneAttribute(value="primaryObligorReference")
        public ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder getPrimaryObligorReference() {
            return this.primaryObligorReference;
        }

        @Override
        public ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder getOrCreatePrimaryObligorReference() {
            ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder result = this.primaryObligorReference != null ? this.primaryObligorReference : (this.primaryObligorReference = ReferenceWithMetaLegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="guarantor")
        @RuneAttribute(value="guarantor")
        public LegalEntity.LegalEntityBuilder getGuarantor() {
            return this.guarantor;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateGuarantor() {
            LegalEntity.LegalEntityBuilder result = this.guarantor != null ? this.guarantor : (this.guarantor = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="guarantorReference")
        @RuneAttribute(value="guarantorReference")
        public String getGuarantorReference() {
            return this.guarantorReference;
        }

        @Override
        @RosettaAttribute(value="standardReferenceObligation")
        @RuneAttribute(value="standardReferenceObligation")
        public Boolean getStandardReferenceObligation() {
            return this.standardReferenceObligation;
        }

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public ReferenceObligationBuilder setSecurity(Security _security) {
            this.security = _security == null ? null : _security.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public ReferenceObligationBuilder setLoan(Loan _loan) {
            this.loan = _loan == null ? null : _loan.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryObligor")
        @RuneAttribute(value="primaryObligor")
        public ReferenceObligationBuilder setPrimaryObligor(LegalEntity _primaryObligor) {
            this.primaryObligor = _primaryObligor == null ? null : _primaryObligor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryObligorReference")
        @RuneAttribute(value="primaryObligorReference")
        public ReferenceObligationBuilder setPrimaryObligorReference(ReferenceWithMetaLegalEntity _primaryObligorReference) {
            this.primaryObligorReference = _primaryObligorReference == null ? null : _primaryObligorReference.toBuilder();
            return this;
        }

        @Override
        public ReferenceObligationBuilder setPrimaryObligorReferenceValue(LegalEntity _primaryObligorReference) {
            this.getOrCreatePrimaryObligorReference().setValue(_primaryObligorReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="guarantor")
        @RuneAttribute(value="guarantor")
        public ReferenceObligationBuilder setGuarantor(LegalEntity _guarantor) {
            this.guarantor = _guarantor == null ? null : _guarantor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="guarantorReference")
        @RuneAttribute(value="guarantorReference")
        public ReferenceObligationBuilder setGuarantorReference(String _guarantorReference) {
            this.guarantorReference = _guarantorReference == null ? null : _guarantorReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="standardReferenceObligation")
        @RuneAttribute(value="standardReferenceObligation")
        public ReferenceObligationBuilder setStandardReferenceObligation(Boolean _standardReferenceObligation) {
            this.standardReferenceObligation = _standardReferenceObligation == null ? null : _standardReferenceObligation;
            return this;
        }

        @Override
        public ReferenceObligation build() {
            return new ReferenceObligationImpl(this);
        }

        @Override
        public ReferenceObligationBuilder toBuilder() {
            return this;
        }

        @Override
        public ReferenceObligationBuilder prune() {
            if (this.security != null && !this.security.prune().hasData()) {
                this.security = null;
            }
            if (this.loan != null && !this.loan.prune().hasData()) {
                this.loan = null;
            }
            if (this.primaryObligor != null && !this.primaryObligor.prune().hasData()) {
                this.primaryObligor = null;
            }
            if (this.primaryObligorReference != null && !this.primaryObligorReference.prune().hasData()) {
                this.primaryObligorReference = null;
            }
            if (this.guarantor != null && !this.guarantor.prune().hasData()) {
                this.guarantor = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSecurity() != null && this.getSecurity().hasData()) {
                return true;
            }
            if (this.getLoan() != null && this.getLoan().hasData()) {
                return true;
            }
            if (this.getPrimaryObligor() != null && this.getPrimaryObligor().hasData()) {
                return true;
            }
            if (this.getPrimaryObligorReference() != null && this.getPrimaryObligorReference().hasData()) {
                return true;
            }
            if (this.getGuarantor() != null && this.getGuarantor().hasData()) {
                return true;
            }
            if (this.getGuarantorReference() != null) {
                return true;
            }
            return this.getStandardReferenceObligation() != null;
        }

        public ReferenceObligationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReferenceObligationBuilder o = (ReferenceObligationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurity(), (RosettaModelObjectBuilder)o.getSecurity(), this::setSecurity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoan(), (RosettaModelObjectBuilder)o.getLoan(), this::setLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryObligor(), (RosettaModelObjectBuilder)o.getPrimaryObligor(), this::setPrimaryObligor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryObligorReference(), (RosettaModelObjectBuilder)o.getPrimaryObligorReference(), this::setPrimaryObligorReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGuarantor(), (RosettaModelObjectBuilder)o.getGuarantor(), this::setGuarantor);
            merger.mergeBasic((Object)this.getGuarantorReference(), (Object)o.getGuarantorReference(), this::setGuarantorReference, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStandardReferenceObligation(), (Object)o.getStandardReferenceObligation(), this::setStandardReferenceObligation, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceObligation _that = this.getType().cast(o);
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligor, _that.getPrimaryObligor())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligorReference, _that.getPrimaryObligorReference())) {
                return false;
            }
            if (!Objects.equals(this.guarantor, _that.getGuarantor())) {
                return false;
            }
            if (!Objects.equals(this.guarantorReference, _that.getGuarantorReference())) {
                return false;
            }
            return Objects.equals(this.standardReferenceObligation, _that.getStandardReferenceObligation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligor != null ? this.primaryObligor.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligorReference != null ? this.primaryObligorReference.hashCode() : 0);
            _result = 31 * _result + (this.guarantor != null ? this.guarantor.hashCode() : 0);
            _result = 31 * _result + (this.guarantorReference != null ? this.guarantorReference.hashCode() : 0);
            _result = 31 * _result + (this.standardReferenceObligation != null ? this.standardReferenceObligation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceObligationBuilder {security=" + this.security + ", loan=" + this.loan + ", primaryObligor=" + this.primaryObligor + ", primaryObligorReference=" + this.primaryObligorReference + ", guarantor=" + this.guarantor + ", guarantorReference=" + this.guarantorReference + ", standardReferenceObligation=" + this.standardReferenceObligation + '}';
        }
    }

    public static interface ReferenceObligationBuilder
    extends ReferenceObligation,
    RosettaModelObjectBuilder {
        public Security.SecurityBuilder getOrCreateSecurity();

        @Override
        public Security.SecurityBuilder getSecurity();

        public Loan.LoanBuilder getOrCreateLoan();

        @Override
        public Loan.LoanBuilder getLoan();

        public LegalEntity.LegalEntityBuilder getOrCreatePrimaryObligor();

        @Override
        public LegalEntity.LegalEntityBuilder getPrimaryObligor();

        public ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder getOrCreatePrimaryObligorReference();

        @Override
        public ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder getPrimaryObligorReference();

        public LegalEntity.LegalEntityBuilder getOrCreateGuarantor();

        @Override
        public LegalEntity.LegalEntityBuilder getGuarantor();

        public ReferenceObligationBuilder setSecurity(Security var1);

        public ReferenceObligationBuilder setLoan(Loan var1);

        public ReferenceObligationBuilder setPrimaryObligor(LegalEntity var1);

        public ReferenceObligationBuilder setPrimaryObligorReference(ReferenceWithMetaLegalEntity var1);

        public ReferenceObligationBuilder setPrimaryObligorReferenceValue(LegalEntity var1);

        public ReferenceObligationBuilder setGuarantor(LegalEntity var1);

        public ReferenceObligationBuilder setGuarantorReference(String var1);

        public ReferenceObligationBuilder setStandardReferenceObligation(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("security"), processor, Security.SecurityBuilder.class, this.getSecurity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loan"), processor, Loan.LoanBuilder.class, this.getLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("primaryObligor"), processor, LegalEntity.LegalEntityBuilder.class, this.getPrimaryObligor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("primaryObligorReference"), processor, ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder.class, this.getPrimaryObligorReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("guarantor"), processor, LegalEntity.LegalEntityBuilder.class, this.getGuarantor(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("guarantorReference"), String.class, (Object)this.getGuarantorReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("standardReferenceObligation"), Boolean.class, (Object)this.getStandardReferenceObligation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ReferenceObligationBuilder prune();
    }

    public static class ReferenceObligationImpl
    implements ReferenceObligation {
        private final Security security;
        private final Loan loan;
        private final LegalEntity primaryObligor;
        private final ReferenceWithMetaLegalEntity primaryObligorReference;
        private final LegalEntity guarantor;
        private final String guarantorReference;
        private final Boolean standardReferenceObligation;

        protected ReferenceObligationImpl(ReferenceObligationBuilder builder) {
            this.security = Optional.ofNullable(builder.getSecurity()).map(f -> f.build()).orElse(null);
            this.loan = Optional.ofNullable(builder.getLoan()).map(f -> f.build()).orElse(null);
            this.primaryObligor = Optional.ofNullable(builder.getPrimaryObligor()).map(f -> f.build()).orElse(null);
            this.primaryObligorReference = Optional.ofNullable(builder.getPrimaryObligorReference()).map(f -> f.build()).orElse(null);
            this.guarantor = Optional.ofNullable(builder.getGuarantor()).map(f -> f.build()).orElse(null);
            this.guarantorReference = builder.getGuarantorReference();
            this.standardReferenceObligation = builder.getStandardReferenceObligation();
        }

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public Security getSecurity() {
            return this.security;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public Loan getLoan() {
            return this.loan;
        }

        @Override
        @RosettaAttribute(value="primaryObligor")
        @RuneAttribute(value="primaryObligor")
        public LegalEntity getPrimaryObligor() {
            return this.primaryObligor;
        }

        @Override
        @RosettaAttribute(value="primaryObligorReference")
        @RuneAttribute(value="primaryObligorReference")
        public ReferenceWithMetaLegalEntity getPrimaryObligorReference() {
            return this.primaryObligorReference;
        }

        @Override
        @RosettaAttribute(value="guarantor")
        @RuneAttribute(value="guarantor")
        public LegalEntity getGuarantor() {
            return this.guarantor;
        }

        @Override
        @RosettaAttribute(value="guarantorReference")
        @RuneAttribute(value="guarantorReference")
        public String getGuarantorReference() {
            return this.guarantorReference;
        }

        @Override
        @RosettaAttribute(value="standardReferenceObligation")
        @RuneAttribute(value="standardReferenceObligation")
        public Boolean getStandardReferenceObligation() {
            return this.standardReferenceObligation;
        }

        @Override
        public ReferenceObligation build() {
            return this;
        }

        @Override
        public ReferenceObligationBuilder toBuilder() {
            ReferenceObligationBuilder builder = ReferenceObligation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReferenceObligationBuilder builder) {
            Optional.ofNullable(this.getSecurity()).ifPresent(builder::setSecurity);
            Optional.ofNullable(this.getLoan()).ifPresent(builder::setLoan);
            Optional.ofNullable(this.getPrimaryObligor()).ifPresent(builder::setPrimaryObligor);
            Optional.ofNullable(this.getPrimaryObligorReference()).ifPresent(builder::setPrimaryObligorReference);
            Optional.ofNullable(this.getGuarantor()).ifPresent(builder::setGuarantor);
            Optional.ofNullable(this.getGuarantorReference()).ifPresent(builder::setGuarantorReference);
            Optional.ofNullable(this.getStandardReferenceObligation()).ifPresent(builder::setStandardReferenceObligation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceObligation _that = this.getType().cast(o);
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligor, _that.getPrimaryObligor())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligorReference, _that.getPrimaryObligorReference())) {
                return false;
            }
            if (!Objects.equals(this.guarantor, _that.getGuarantor())) {
                return false;
            }
            if (!Objects.equals(this.guarantorReference, _that.getGuarantorReference())) {
                return false;
            }
            return Objects.equals(this.standardReferenceObligation, _that.getStandardReferenceObligation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligor != null ? this.primaryObligor.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligorReference != null ? this.primaryObligorReference.hashCode() : 0);
            _result = 31 * _result + (this.guarantor != null ? this.guarantor.hashCode() : 0);
            _result = 31 * _result + (this.guarantorReference != null ? this.guarantorReference.hashCode() : 0);
            _result = 31 * _result + (this.standardReferenceObligation != null ? this.standardReferenceObligation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceObligation {security=" + this.security + ", loan=" + this.loan + ", primaryObligor=" + this.primaryObligor + ", primaryObligorReference=" + this.primaryObligorReference + ", guarantor=" + this.guarantor + ", guarantorReference=" + this.guarantorReference + ", standardReferenceObligation=" + this.standardReferenceObligation + '}';
        }
    }
}

